/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.example.pagerank;

import edu.umd.cloud9.example.pagerank.PageRankNode;
import edu.umd.cloud9.example.pagerank.RangePartitioner;
import edu.umd.cloud9.mapreduce.lib.input.NonSplitableSequenceFileInputFormat;
import java.io.PrintStream;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;

public class PartitionGraph
extends Configured
implements Tool {
    private static final Logger LOG = Logger.getLogger(PartitionGraph.class);
    private static final String INPUT = "input";
    private static final String OUTPUT = "output";
    private static final String NUM_NODES = "numNodes";
    private static final String NUM_PARTITIONS = "numPartitions";
    private static final String RANGE = "range";

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new PartitionGraph(), (String[])args);
    }

    public int run(String[] args) throws Exception {
        CommandLine cmdline;
        Options options = new Options();
        options.addOption(new Option(RANGE, "use range partitioner"));
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"input path");
        options.addOption(OptionBuilder.create((String)INPUT));
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"output path");
        options.addOption(OptionBuilder.create((String)OUTPUT));
        OptionBuilder.withArgName((String)"num");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"number of nodes");
        options.addOption(OptionBuilder.create((String)NUM_NODES));
        OptionBuilder.withArgName((String)"num");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"number of partitions");
        options.addOption(OptionBuilder.create((String)NUM_PARTITIONS));
        GnuParser parser = new GnuParser();
        try {
            cmdline = parser.parse(options, args);
        }
        catch (ParseException exp) {
            System.err.println("Error parsing command line: " + exp.getMessage());
            return -1;
        }
        if (!(cmdline.hasOption(INPUT) && cmdline.hasOption(OUTPUT) && cmdline.hasOption(NUM_NODES) && cmdline.hasOption(NUM_PARTITIONS))) {
            System.out.println("args: " + Arrays.toString(args));
            HelpFormatter formatter = new HelpFormatter();
            formatter.setWidth(120);
            formatter.printHelp(((Object)((Object)this)).getClass().getName(), options);
            ToolRunner.printGenericCommandUsage((PrintStream)System.out);
            return -1;
        }
        String inPath = cmdline.getOptionValue(INPUT);
        String outPath = cmdline.getOptionValue(OUTPUT);
        int nodeCount = Integer.parseInt(cmdline.getOptionValue(NUM_NODES));
        int numParts = Integer.parseInt(cmdline.getOptionValue(NUM_PARTITIONS));
        boolean useRange = cmdline.hasOption(RANGE);
        LOG.info((Object)("Tool name: " + PartitionGraph.class.getSimpleName()));
        LOG.info((Object)(" - input dir: " + inPath));
        LOG.info((Object)(" - output dir: " + outPath));
        LOG.info((Object)(" - num partitions: " + numParts));
        LOG.info((Object)(" - node cnt: " + nodeCount));
        LOG.info((Object)(" - use range partitioner: " + useRange));
        Configuration conf = this.getConf();
        conf.setInt("NodeCount", nodeCount);
        Job job = Job.getInstance((Configuration)conf);
        job.setJobName(PartitionGraph.class.getSimpleName() + ":" + inPath);
        job.setJarByClass(PartitionGraph.class);
        job.setNumReduceTasks(numParts);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(inPath)});
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(outPath));
        job.setInputFormatClass(NonSplitableSequenceFileInputFormat.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.setMapOutputKeyClass(IntWritable.class);
        job.setMapOutputValueClass(PageRankNode.class);
        job.setOutputKeyClass(IntWritable.class);
        job.setOutputValueClass(PageRankNode.class);
        if (useRange) {
            job.setPartitionerClass(RangePartitioner.class);
        }
        FileSystem.get((Configuration)conf).delete(new Path(outPath), true);
        job.waitForCompletion(true);
        return 0;
    }
}

