/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.example.pagerank;

import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Partitioner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangePartitioner
extends Partitioner<IntWritable, Writable>
implements Configurable {
    private int nodeCnt = 0;
    private Configuration conf;

    public int getPartition(IntWritable key, Writable value, int numReduceTasks) {
        return (int)((float)key.get() / (float)this.nodeCnt * (float)numReduceTasks) % numReduceTasks;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.configure();
    }

    private void configure() {
        this.nodeCnt = this.conf.getInt("NodeCount", 0);
    }
}

