/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.example.pagerank;

import com.google.common.base.Preconditions;
import edu.umd.cloud9.example.pagerank.PageRankNode;
import edu.umd.cloud9.mapreduce.lib.input.NonSplitableSequenceFileInputFormat;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;
import tl.lin.data.array.ArrayListOfIntsWritable;
import tl.lin.data.map.HMapIF;
import tl.lin.data.map.MapIF;

public class RunPageRankBasic
extends Configured
implements Tool {
    private static final Logger LOG = Logger.getLogger(RunPageRankBasic.class);
    private static float ALPHA = 0.15f;
    private static NumberFormat formatter = new DecimalFormat("0000");
    private static final String BASE = "base";
    private static final String NUM_NODES = "numNodes";
    private static final String START = "start";
    private static final String END = "end";
    private static final String COMBINER = "useCombiner";
    private static final String INMAPPER_COMBINER = "useInMapperCombiner";
    private static final String RANGE = "range";

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new RunPageRankBasic(), (String[])args);
    }

    public int run(String[] args) throws Exception {
        CommandLine cmdline;
        Options options = new Options();
        options.addOption(new Option(COMBINER, "use combiner"));
        options.addOption(new Option(INMAPPER_COMBINER, "user in-mapper combiner"));
        options.addOption(new Option(RANGE, "use range partitioner"));
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"base path");
        options.addOption(OptionBuilder.create((String)BASE));
        OptionBuilder.withArgName((String)"num");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"start iteration");
        options.addOption(OptionBuilder.create((String)START));
        OptionBuilder.withArgName((String)"num");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"end iteration");
        options.addOption(OptionBuilder.create((String)END));
        OptionBuilder.withArgName((String)"num");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"number of nodes");
        options.addOption(OptionBuilder.create((String)NUM_NODES));
        GnuParser parser = new GnuParser();
        try {
            cmdline = parser.parse(options, args);
        }
        catch (ParseException exp) {
            System.err.println("Error parsing command line: " + exp.getMessage());
            return -1;
        }
        if (!(cmdline.hasOption(BASE) && cmdline.hasOption(START) && cmdline.hasOption(END) && cmdline.hasOption(NUM_NODES))) {
            System.out.println("args: " + Arrays.toString(args));
            HelpFormatter formatter = new HelpFormatter();
            formatter.setWidth(120);
            formatter.printHelp(((Object)((Object)this)).getClass().getName(), options);
            ToolRunner.printGenericCommandUsage((PrintStream)System.out);
            return -1;
        }
        String basePath = cmdline.getOptionValue(BASE);
        int n = Integer.parseInt(cmdline.getOptionValue(NUM_NODES));
        int s = Integer.parseInt(cmdline.getOptionValue(START));
        int e = Integer.parseInt(cmdline.getOptionValue(END));
        boolean useCombiner = cmdline.hasOption(COMBINER);
        boolean useInmapCombiner = cmdline.hasOption(INMAPPER_COMBINER);
        boolean useRange = cmdline.hasOption(RANGE);
        LOG.info((Object)"Tool name: RunPageRank");
        LOG.info((Object)(" - base path: " + basePath));
        LOG.info((Object)(" - num nodes: " + n));
        LOG.info((Object)(" - start iteration: " + s));
        LOG.info((Object)(" - end iteration: " + e));
        LOG.info((Object)(" - use combiner: " + useCombiner));
        LOG.info((Object)(" - use in-mapper combiner: " + useInmapCombiner));
        LOG.info((Object)(" - user range partitioner: " + useRange));
        for (int i = s; i < e; ++i) {
            this.iteratePageRank(i, i + 1, basePath, n, useCombiner, useInmapCombiner);
        }
        return 0;
    }

    private void iteratePageRank(int i, int j, String basePath, int numNodes, boolean useCombiner, boolean useInMapperCombiner) throws Exception {
        float mass = this.phase1(i, j, basePath, numNodes, useCombiner, useInMapperCombiner);
        float missing = 1.0f - (float)StrictMath.exp(mass);
        this.phase2(i, j, missing, basePath, numNodes);
    }

    private float phase1(int i, int j, String basePath, int numNodes, boolean useCombiner, boolean useInMapperCombiner) throws Exception {
        Job job = Job.getInstance((Configuration)this.getConf());
        job.setJobName("PageRank:Basic:iteration" + j + ":Phase1");
        job.setJarByClass(RunPageRankBasic.class);
        String in = basePath + "/iter" + formatter.format(i);
        String out = basePath + "/iter" + formatter.format(j) + "t";
        String outm = out + "-mass";
        int numPartitions = 0;
        for (FileStatus s : FileSystem.get((Configuration)this.getConf()).listStatus(new Path(in))) {
            if (!s.getPath().getName().contains("part-")) continue;
            ++numPartitions;
        }
        LOG.info((Object)("PageRank: iteration " + j + ": Phase1"));
        LOG.info((Object)(" - input: " + in));
        LOG.info((Object)(" - output: " + out));
        LOG.info((Object)(" - nodeCnt: " + numNodes));
        LOG.info((Object)(" - useCombiner: " + useCombiner));
        LOG.info((Object)(" - useInmapCombiner: " + useInMapperCombiner));
        LOG.info((Object)("computed number of partitions: " + numPartitions));
        int numReduceTasks = numPartitions;
        job.getConfiguration().setInt("NodeCount", numNodes);
        job.getConfiguration().setBoolean("mapred.map.tasks.speculative.execution", false);
        job.getConfiguration().setBoolean("mapred.reduce.tasks.speculative.execution", false);
        job.getConfiguration().set("PageRankMassPath", outm);
        job.setNumReduceTasks(numReduceTasks);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(in)});
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(out));
        job.setInputFormatClass(NonSplitableSequenceFileInputFormat.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.setMapOutputKeyClass(IntWritable.class);
        job.setMapOutputValueClass(PageRankNode.class);
        job.setOutputKeyClass(IntWritable.class);
        job.setOutputValueClass(PageRankNode.class);
        job.setMapperClass(useInMapperCombiner ? MapWithInMapperCombiningClass.class : MapClass.class);
        if (useCombiner) {
            job.setCombinerClass(CombineClass.class);
        }
        job.setReducerClass(ReduceClass.class);
        FileSystem.get((Configuration)this.getConf()).delete(new Path(out), true);
        FileSystem.get((Configuration)this.getConf()).delete(new Path(outm), true);
        long startTime = System.currentTimeMillis();
        job.waitForCompletion(true);
        System.out.println("Job Finished in " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds");
        float mass = Float.NEGATIVE_INFINITY;
        FileSystem fs = FileSystem.get((Configuration)this.getConf());
        for (FileStatus f : fs.listStatus(new Path(outm))) {
            FSDataInputStream fin = fs.open(f.getPath());
            mass = RunPageRankBasic.sumLogProbs(mass, fin.readFloat());
            fin.close();
        }
        return mass;
    }

    private void phase2(int i, int j, float missing, String basePath, int numNodes) throws Exception {
        Job job = Job.getInstance((Configuration)this.getConf());
        job.setJobName("PageRank:Basic:iteration" + j + ":Phase2");
        job.setJarByClass(RunPageRankBasic.class);
        LOG.info((Object)("missing PageRank mass: " + missing));
        LOG.info((Object)("number of nodes: " + numNodes));
        String in = basePath + "/iter" + formatter.format(j) + "t";
        String out = basePath + "/iter" + formatter.format(j);
        LOG.info((Object)("PageRank: iteration " + j + ": Phase2"));
        LOG.info((Object)(" - input: " + in));
        LOG.info((Object)(" - output: " + out));
        job.getConfiguration().setBoolean("mapred.map.tasks.speculative.execution", false);
        job.getConfiguration().setBoolean("mapred.reduce.tasks.speculative.execution", false);
        job.getConfiguration().setFloat("MissingMass", missing);
        job.getConfiguration().setInt("NodeCount", numNodes);
        job.setNumReduceTasks(0);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(in)});
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(out));
        job.setInputFormatClass(NonSplitableSequenceFileInputFormat.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.setMapOutputKeyClass(IntWritable.class);
        job.setMapOutputValueClass(PageRankNode.class);
        job.setOutputKeyClass(IntWritable.class);
        job.setOutputValueClass(PageRankNode.class);
        job.setMapperClass(MapPageRankMassDistributionClass.class);
        FileSystem.get((Configuration)this.getConf()).delete(new Path(out), true);
        long startTime = System.currentTimeMillis();
        job.waitForCompletion(true);
        System.out.println("Job Finished in " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds");
    }

    private static float sumLogProbs(float a, float b) {
        if (a == Float.NEGATIVE_INFINITY) {
            return b;
        }
        if (b == Float.NEGATIVE_INFINITY) {
            return a;
        }
        if (a < b) {
            return (float)((double)b + StrictMath.log1p(StrictMath.exp(a - b)));
        }
        return (float)((double)a + StrictMath.log1p(StrictMath.exp(b - a)));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapPageRankMassDistributionClass
    extends Mapper<IntWritable, PageRankNode, IntWritable, PageRankNode> {
        private float missingMass = 0.0f;
        private int nodeCnt = 0;

        private MapPageRankMassDistributionClass() {
        }

        public void setup(Mapper.Context context) throws IOException {
            Configuration conf = context.getConfiguration();
            this.missingMass = conf.getFloat("MissingMass", 0.0f);
            this.nodeCnt = conf.getInt("NodeCount", 0);
        }

        public void map(IntWritable nid, PageRankNode node, Mapper.Context context) throws IOException, InterruptedException {
            float p = node.getPageRank();
            float jump = (float)(Math.log(ALPHA) - Math.log(this.nodeCnt));
            float link = (float)Math.log(1.0f - ALPHA) + RunPageRankBasic.sumLogProbs(p, (float)(Math.log(this.missingMass) - Math.log(this.nodeCnt)));
            p = RunPageRankBasic.sumLogProbs(jump, link);
            node.setPageRank(p);
            context.write((Object)nid, (Object)node);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReduceClass
    extends Reducer<IntWritable, PageRankNode, IntWritable, PageRankNode> {
        private float totalMass = Float.NEGATIVE_INFINITY;

        private ReduceClass() {
        }

        public void reduce(IntWritable nid, Iterable<PageRankNode> iterable, Reducer.Context context) throws IOException, InterruptedException {
            Iterator<PageRankNode> values = iterable.iterator();
            PageRankNode node = new PageRankNode();
            node.setType(PageRankNode.Type.Complete);
            node.setNodeId(nid.get());
            int massMessagesReceived = 0;
            int structureReceived = 0;
            float mass = Float.NEGATIVE_INFINITY;
            while (values.hasNext()) {
                PageRankNode n = values.next();
                if (n.getType().equals((Object)PageRankNode.Type.Structure)) {
                    ArrayListOfIntsWritable list = n.getAdjacenyList();
                    ++structureReceived;
                    node.setAdjacencyList(list);
                    continue;
                }
                mass = RunPageRankBasic.sumLogProbs(mass, n.getPageRank());
                ++massMessagesReceived;
            }
            node.setPageRank(mass);
            context.getCounter((Enum)PageRank.massMessagesReceived).increment((long)massMessagesReceived);
            if (structureReceived == 1) {
                context.write((Object)nid, (Object)node);
                this.totalMass = RunPageRankBasic.sumLogProbs(this.totalMass, mass);
            } else if (structureReceived == 0) {
                context.getCounter((Enum)PageRank.missingStructure).increment(1L);
                LOG.warn((Object)("No structure received for nodeid: " + nid.get() + " mass: " + massMessagesReceived));
            } else {
                throw new RuntimeException("Multiple structure received for nodeid: " + nid.get() + " mass: " + massMessagesReceived + " struct: " + structureReceived);
            }
        }

        public void cleanup(Reducer.Context context) throws IOException {
            Configuration conf = context.getConfiguration();
            String taskId = conf.get("mapred.task.id");
            String path = conf.get("PageRankMassPath");
            Preconditions.checkNotNull((Object)taskId);
            Preconditions.checkNotNull((Object)path);
            FileSystem fs = FileSystem.get((Configuration)context.getConfiguration());
            FSDataOutputStream out = fs.create(new Path(path + "/" + taskId), false);
            out.writeFloat(this.totalMass);
            out.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CombineClass
    extends Reducer<IntWritable, PageRankNode, IntWritable, PageRankNode> {
        private static final PageRankNode intermediateMass = new PageRankNode();

        private CombineClass() {
        }

        public void reduce(IntWritable nid, Iterable<PageRankNode> values, Reducer.Context context) throws IOException, InterruptedException {
            int massMessages = 0;
            float mass = Float.NEGATIVE_INFINITY;
            for (PageRankNode n : values) {
                if (n.getType() == PageRankNode.Type.Structure) {
                    context.write((Object)nid, (Object)n);
                    continue;
                }
                mass = RunPageRankBasic.sumLogProbs(mass, n.getPageRank());
                ++massMessages;
            }
            if (massMessages > 0) {
                intermediateMass.setNodeId(nid.get());
                intermediateMass.setType(PageRankNode.Type.Mass);
                intermediateMass.setPageRank(mass);
                context.write((Object)nid, (Object)intermediateMass);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapWithInMapperCombiningClass
    extends Mapper<IntWritable, PageRankNode, IntWritable, PageRankNode> {
        private static final HMapIF map = new HMapIF();
        private static final PageRankNode intermediateStructure = new PageRankNode();

        private MapWithInMapperCombiningClass() {
        }

        public void map(IntWritable nid, PageRankNode node, Mapper.Context context) throws IOException, InterruptedException {
            intermediateStructure.setNodeId(node.getNodeId());
            intermediateStructure.setType(PageRankNode.Type.Structure);
            intermediateStructure.setAdjacencyList(node.getAdjacenyList());
            context.write((Object)nid, (Object)intermediateStructure);
            int massMessages = 0;
            int massMessagesSaved = 0;
            if (node.getAdjacenyList().size() > 0) {
                ArrayListOfIntsWritable list = node.getAdjacenyList();
                float mass = node.getPageRank() - (float)StrictMath.log(list.size());
                context.getCounter((Enum)PageRank.edges).increment((long)list.size());
                for (int i = 0; i < list.size(); ++i) {
                    int neighbor = list.get(i);
                    if (map.containsKey(neighbor)) {
                        ++massMessagesSaved;
                        map.put(neighbor, RunPageRankBasic.sumLogProbs(MapWithInMapperCombiningClass.map.get(neighbor), mass));
                        continue;
                    }
                    ++massMessages;
                    map.put(neighbor, mass);
                }
            }
            context.getCounter((Enum)PageRank.nodes).increment(1L);
            context.getCounter((Enum)PageRank.massMessages).increment((long)massMessages);
            context.getCounter((Enum)PageRank.massMessagesSaved).increment((long)massMessagesSaved);
        }

        public void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            IntWritable k = new IntWritable();
            PageRankNode mass = new PageRankNode();
            for (MapIF.Entry e : map.entrySet()) {
                k.set(e.getKey());
                mass.setNodeId(e.getKey());
                mass.setType(PageRankNode.Type.Mass);
                mass.setPageRank(e.getValue());
                context.write((Object)k, (Object)mass);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapClass
    extends Mapper<IntWritable, PageRankNode, IntWritable, PageRankNode> {
        private static final IntWritable neighbor = new IntWritable();
        private static final PageRankNode intermediateMass = new PageRankNode();
        private static final PageRankNode intermediateStructure = new PageRankNode();

        private MapClass() {
        }

        public void map(IntWritable nid, PageRankNode node, Mapper.Context context) throws IOException, InterruptedException {
            intermediateStructure.setNodeId(node.getNodeId());
            intermediateStructure.setType(PageRankNode.Type.Structure);
            intermediateStructure.setAdjacencyList(node.getAdjacenyList());
            context.write((Object)nid, (Object)intermediateStructure);
            int massMessages = 0;
            if (node.getAdjacenyList().size() > 0) {
                ArrayListOfIntsWritable list = node.getAdjacenyList();
                float mass = node.getPageRank() - (float)StrictMath.log(list.size());
                context.getCounter((Enum)PageRank.edges).increment((long)list.size());
                for (int i = 0; i < list.size(); ++i) {
                    neighbor.set(list.get(i));
                    intermediateMass.setNodeId(list.get(i));
                    intermediateMass.setType(PageRankNode.Type.Mass);
                    intermediateMass.setPageRank(mass);
                    context.write((Object)neighbor, (Object)intermediateMass);
                    ++massMessages;
                }
            }
            context.getCounter((Enum)PageRank.nodes).increment(1L);
            context.getCounter((Enum)PageRank.massMessages).increment((long)massMessages);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PageRank {
        nodes,
        edges,
        massMessages,
        massMessagesSaved,
        massMessagesReceived,
        missingStructure;

    }
}

