/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.example.simple;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.log4j.Logger;
import org.apache.pig.data.BinSedesTuple;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

public class DemoPackTuples2 {
    private static final Logger LOG = Logger.getLogger(DemoPackTuples2.class);
    private static final TupleFactory TUPLE_FACTORY = TupleFactory.getInstance();

    private DemoPackTuples2() {
    }

    public static void main(String[] args) throws IOException {
        String line;
        if (args.length != 2) {
            System.out.println("usage: [input] [output]");
            System.exit(-1);
        }
        String infile = args[0];
        String outfile = args[1];
        LOG.info((Object)("input: " + infile));
        LOG.info((Object)("output: " + outfile));
        Configuration conf = new Configuration();
        SequenceFile.Writer writer = SequenceFile.createWriter((Configuration)conf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)new Path(outfile)), SequenceFile.Writer.keyClass(LongWritable.class), SequenceFile.Writer.valueClass(BinSedesTuple.class)});
        BufferedReader data = new BufferedReader(new InputStreamReader(new FileInputStream(infile)));
        LongWritable l = new LongWritable();
        long cnt = 0L;
        while ((line = data.readLine()) != null) {
            Tuple tuple = TUPLE_FACTORY.newTuple();
            tuple.append((Object)new Integer(line.length()));
            StringTokenizer itr = new StringTokenizer(line);
            while (itr.hasMoreTokens()) {
                tuple.append((Object)itr.nextToken());
            }
            l.set(cnt);
            writer.append((Writable)l, (Writable)tuple);
            ++cnt;
        }
        data.close();
        writer.close();
        LOG.info((Object)("Wrote " + cnt + " records."));
    }
}

