/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.example.simple;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;
import tl.lin.data.JsonWritable;

public class DemoWordCountJson
extends Configured
implements Tool {
    private static final Logger LOG = Logger.getLogger(DemoWordCountJson.class);

    private static int printUsage() {
        System.out.println("usage: [input-path] [output-path] [num-reducers]");
        ToolRunner.printGenericCommandUsage((PrintStream)System.out);
        return -1;
    }

    public int run(String[] args) throws Exception {
        if (args.length != 3) {
            DemoWordCountJson.printUsage();
            return -1;
        }
        String inputPath = args[0];
        String outputPath = args[1];
        int numReduceTasks = Integer.parseInt(args[2]);
        LOG.info((Object)("Tool: " + DemoWordCountJson.class.getSimpleName()));
        LOG.info((Object)(" - input path: " + inputPath));
        LOG.info((Object)(" - output path: " + outputPath));
        LOG.info((Object)(" - number of reducers: " + numReduceTasks));
        Configuration conf = this.getConf();
        Job job = Job.getInstance((Configuration)conf);
        job.setJobName(DemoWordCountJson.class.getSimpleName());
        job.setJarByClass(DemoWordCountJson.class);
        job.setNumReduceTasks(numReduceTasks);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(inputPath)});
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(outputPath));
        job.setInputFormatClass(SequenceFileInputFormat.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.setOutputKeyClass(MyKey.class);
        job.setOutputValueClass(IntWritable.class);
        job.setMapperClass(MyMapper.class);
        job.setCombinerClass(MyReducer.class);
        job.setReducerClass(MyReducer.class);
        Path outputDir = new Path(outputPath);
        FileSystem.get((Configuration)conf).delete(outputDir, true);
        long startTime = System.currentTimeMillis();
        job.waitForCompletion(true);
        LOG.info((Object)("Job Finished in " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds"));
        return 0;
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new DemoWordCountJson(), (String[])args);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MyReducer
    extends Reducer<MyKey, IntWritable, MyKey, IntWritable> {
        private static final IntWritable SUM = new IntWritable();

        protected MyReducer() {
        }

        public void reduce(MyKey keyIn, Iterable<IntWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            Iterator<IntWritable> iter = values.iterator();
            int sum = 0;
            while (iter.hasNext()) {
                sum += iter.next().get();
            }
            SUM.set(sum);
            context.write((Object)keyIn, (Object)SUM);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MyMapper
    extends Mapper<LongWritable, JsonWritable, MyKey, IntWritable> {
        private static final IntWritable ONE = new IntWritable(1);
        private static final MyKey KEY = new MyKey();

        protected MyMapper() {
        }

        public void map(LongWritable dummy, JsonWritable jsonIn, Mapper.Context context) throws IOException, InterruptedException {
            String line = jsonIn.getJsonObject().get("text").getAsString();
            StringTokenizer itr = new StringTokenizer(line);
            while (itr.hasMoreTokens()) {
                String token = itr.nextToken();
                KEY.getJsonObject().addProperty("Token", token);
                KEY.getJsonObject().addProperty("EvenOrOdd", (Number)(line.length() % 2));
                context.write((Object)KEY, (Object)ONE);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MyKey
    extends JsonWritable
    implements WritableComparable<MyKey> {
        public int compareTo(MyKey that) {
            String thatToken;
            String thisToken = this.getJsonObject().get("Token").getAsString();
            if (thisToken.equals(thatToken = that.getJsonObject().get("Token").getAsString())) {
                int thatEO;
                int thisEO = this.getJsonObject().get("EvenOrOdd").getAsInt();
                if (thisEO < (thatEO = that.getJsonObject().get("EvenOrOdd").getAsInt())) {
                    return -1;
                }
                if (thisEO > thatEO) {
                    return 1;
                }
                return 0;
            }
            return thisToken.compareTo(thatToken);
        }

        public int hashCode() {
            return this.getJsonObject().getAsJsonPrimitive("Token").getAsString().hashCode();
        }
    }
}

