/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import tl.lin.data.pair.PairOfWritables;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceFileUtils {
    private static final TupleFactory TUPLE_FACTORY = TupleFactory.getInstance();

    private SequenceFileUtils() {
    }

    public static <K extends Writable, V extends Writable> List<PairOfWritables<K, V>> readFile(Path path) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        return SequenceFileUtils.readFile(path, fs, Integer.MAX_VALUE);
    }

    public static <K extends Writable, V extends Writable> List<PairOfWritables<K, V>> readFile(Path path, int max) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        return SequenceFileUtils.readFile(path, fs, max);
    }

    public static <K extends Writable, V extends Writable> List<PairOfWritables<K, V>> readFile(Path path, FileSystem fs) throws IOException {
        return SequenceFileUtils.readFile(path, fs, Integer.MAX_VALUE);
    }

    public static <K extends Writable, V extends Writable> List<PairOfWritables<K, V>> readFile(Path path, FileSystem fs, int max) throws IOException {
        ArrayList<PairOfWritables<K, V>> list = new ArrayList<PairOfWritables<K, V>>();
        try {
            int k = 0;
            SequenceFile.Reader reader = new SequenceFile.Reader(fs, path, fs.getConf());
            Object key = Tuple.class.isAssignableFrom(reader.getKeyClass()) ? TUPLE_FACTORY.newTuple() : (Writable)reader.getKeyClass().newInstance();
            Object value = Tuple.class.isAssignableFrom(reader.getValueClass()) ? TUPLE_FACTORY.newTuple() : (Writable)reader.getValueClass().newInstance();
            while (reader.next((Writable)key, (Writable)value)) {
                list.add(new PairOfWritables((Writable)key, (Writable)value));
                if (++k >= max) break;
                key = Tuple.class.isAssignableFrom(reader.getKeyClass()) ? TUPLE_FACTORY.newTuple() : (Writable)reader.getKeyClass().newInstance();
                if (Tuple.class.isAssignableFrom(reader.getValueClass())) {
                    value = TUPLE_FACTORY.newTuple();
                    continue;
                }
                value = (Writable)reader.getValueClass().newInstance();
            }
            reader.close();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error reading SequenceFile: " + e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Error reading SequenceFile: " + e);
        }
        return list;
    }

    public static <K extends Writable, V extends Writable> SortedMap<K, V> readFileIntoMap(Path path) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        return SequenceFileUtils.readFileIntoMap(path, fs, Integer.MAX_VALUE);
    }

    public static <K extends Writable, V extends Writable> SortedMap<K, V> readFileIntoMap(Path path, int max) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        return SequenceFileUtils.readFileIntoMap(path, fs, max);
    }

    public static <K extends Writable, V extends Writable> SortedMap<K, V> readFileIntoMap(Path path, FileSystem fs) throws IOException {
        return SequenceFileUtils.readFileIntoMap(path, fs, Integer.MAX_VALUE);
    }

    public static <K extends Writable, V extends Writable> SortedMap<K, V> readFileIntoMap(Path path, FileSystem fs, int max) throws IOException {
        TreeMap<Writable, Writable> map = new TreeMap<Writable, Writable>();
        for (PairOfWritables<K, V> pair : SequenceFileUtils.readFile(path, fs, max)) {
            map.put(pair.getLeftElement(), pair.getRightElement());
        }
        return map;
    }

    public static <K extends Writable, V extends Writable> List<PairOfWritables<K, V>> readDirectory(Path path) {
        FileSystem fs;
        try {
            fs = FileSystem.get((Configuration)new Configuration());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to access the file system!");
        }
        return SequenceFileUtils.readDirectory(path, fs, Integer.MAX_VALUE);
    }

    public static <K extends Writable, V extends Writable> List<PairOfWritables<K, V>> readDirectory(Path path, FileSystem fs, int max) {
        ArrayList<PairOfWritables<K, V>> list = new ArrayList<PairOfWritables<K, V>>();
        try {
            FileStatus[] stat = fs.listStatus(path);
            for (int i = 0; i < stat.length; ++i) {
                if (stat[i].getPath().getName().startsWith("_")) continue;
                List<PairOfWritables<K, V>> pairs = SequenceFileUtils.readFile(stat[i].getPath(), fs, max);
                list.addAll(pairs);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading the file system!");
        }
        return list;
    }

    public static <K extends Writable> List<K> readKeys(Path path) {
        FileSystem fs;
        try {
            fs = FileSystem.get((Configuration)new Configuration());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to access the file system!");
        }
        return SequenceFileUtils.readKeys(path, fs, Integer.MAX_VALUE);
    }

    public static <K extends Writable> List<K> readKeys(Path path, int max) {
        FileSystem fs;
        try {
            fs = FileSystem.get((Configuration)new Configuration());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to access the file system!");
        }
        return SequenceFileUtils.readKeys(path, fs, max);
    }

    public static <K extends Writable> List<K> readKeys(Path path, FileSystem fs) {
        return SequenceFileUtils.readKeys(path, fs, Integer.MAX_VALUE);
    }

    public static <K extends Writable> List<K> readKeys(Path path, FileSystem fs, int max) {
        ArrayList<Writable> list = new ArrayList<Writable>();
        try {
            int k = 0;
            SequenceFile.Reader reader = new SequenceFile.Reader(fs, path, fs.getConf());
            Writable key = (Writable)reader.getKeyClass().newInstance();
            Writable value = (Writable)reader.getValueClass().newInstance();
            while (reader.next(key, value)) {
                list.add(key);
                if (++k >= max) break;
                key = (Writable)reader.getKeyClass().newInstance();
            }
            reader.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading SequenceFile " + path);
        }
        return list;
    }

    public static <V extends Writable> List<V> readValues(Path path) {
        FileSystem fs;
        try {
            fs = FileSystem.get((Configuration)new Configuration());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to access the file system!");
        }
        return SequenceFileUtils.readValues(path, fs, Integer.MAX_VALUE);
    }

    public static <V extends Writable> List<V> readValues(Path path, int max) {
        FileSystem fs;
        try {
            fs = FileSystem.get((Configuration)new Configuration());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to access the file system!");
        }
        return SequenceFileUtils.readValues(path, fs, max);
    }

    public static <V extends Writable> List<V> readValues(Path path, FileSystem fs) {
        return SequenceFileUtils.readValues(path, fs, Integer.MAX_VALUE);
    }

    public static <V extends Writable> List<V> readValues(Path path, FileSystem fs, int max) {
        ArrayList<Writable> list = new ArrayList<Writable>();
        try {
            int k = 0;
            SequenceFile.Reader reader = new SequenceFile.Reader(fs, path, fs.getConf());
            Writable key = (Writable)reader.getKeyClass().newInstance();
            Writable value = (Writable)reader.getValueClass().newInstance();
            while (reader.next(key, value)) {
                list.add(value);
                if (++k >= max) break;
                value = (Writable)reader.getValueClass().newInstance();
            }
            reader.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading SequenceFile " + path);
        }
        return list;
    }
}

