/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io;

import java.io.UTFDataFormatException;
import org.apache.hadoop.io.WritableComparator;

public class WritableComparatorUtils {
    public static String readUTF(byte[] bytes, int s) {
        try {
            int c;
            int count;
            int utflen = WritableComparator.readUnsignedShort((byte[])bytes, (int)s);
            byte[] bytearr = new byte[utflen];
            char[] chararr = new char[utflen];
            int chararr_count = 0;
            System.arraycopy(bytes, s + 2, bytearr, 0, utflen);
            for (count = 0; count < utflen && (c = bytearr[count] & 0xFF) <= 127; ++count) {
                chararr[chararr_count++] = (char)c;
            }
            block8: while (count < utflen) {
                c = bytearr[count] & 0xFF;
                switch (c >> 4) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        ++count;
                        chararr[chararr_count++] = (char)c;
                        continue block8;
                    }
                    case 12: 
                    case 13: {
                        if ((count += 2) > utflen) {
                            throw new UTFDataFormatException("malformed input: partial character at end");
                        }
                        byte char2 = bytearr[count - 1];
                        if ((char2 & 0xC0) != 128) {
                            throw new UTFDataFormatException("malformed input around byte " + count);
                        }
                        chararr[chararr_count++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                        continue block8;
                    }
                    case 14: {
                        if ((count += 3) > utflen) {
                            throw new UTFDataFormatException("malformed input: partial character at end");
                        }
                        byte char2 = bytearr[count - 2];
                        byte char3 = bytearr[count - 1];
                        if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                            throw new UTFDataFormatException("malformed input around byte " + (count - 1));
                        }
                        chararr[chararr_count++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                        continue block8;
                    }
                }
                throw new UTFDataFormatException("malformed input around byte " + count);
            }
            return new String(chararr, 0, chararr_count);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

