/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.io.triple;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TripleOfInts
implements WritableComparable<TripleOfInts> {
    private int leftElement;
    private int middleElement;
    private int rightElement;

    public TripleOfInts() {
    }

    public TripleOfInts(int left, int middle, int right) {
        this.set(left, middle, right);
    }

    public void readFields(DataInput in) throws IOException {
        this.leftElement = in.readInt();
        this.middleElement = in.readInt();
        this.rightElement = in.readInt();
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.leftElement);
        out.writeInt(this.middleElement);
        out.writeInt(this.rightElement);
    }

    public int getLeftElement() {
        return this.leftElement;
    }

    public int getMiddleElement() {
        return this.middleElement;
    }

    public int getRightElement() {
        return this.rightElement;
    }

    public void set(int left, int middle, int right) {
        this.leftElement = left;
        this.middleElement = middle;
        this.rightElement = right;
    }

    public boolean equals(Object obj) {
        TripleOfInts threeInts = (TripleOfInts)obj;
        return this.leftElement == threeInts.getLeftElement() && this.middleElement == threeInts.getMiddleElement() && this.rightElement == threeInts.getRightElement();
    }

    public int compareTo(TripleOfInts obj) {
        TripleOfInts threeInts = obj;
        int pl = threeInts.getLeftElement();
        int pm = threeInts.getMiddleElement();
        int pr = threeInts.getRightElement();
        if (this.leftElement < pl) {
            return -1;
        }
        if (this.leftElement > pl) {
            return 1;
        }
        if (this.middleElement < pm) {
            return -1;
        }
        if (this.middleElement > pm) {
            return 1;
        }
        if (this.rightElement < pr) {
            return -1;
        }
        if (this.rightElement > pr) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        return this.leftElement + this.middleElement + this.rightElement;
    }

    public String toString() {
        return "(" + this.leftElement + ", " + this.middleElement + ", " + this.rightElement + ")";
    }

    public TripleOfInts clone() {
        return new TripleOfInts(this.leftElement, this.middleElement, this.rightElement);
    }

    static {
        WritableComparator.define(TripleOfInts.class, (WritableComparator)new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(TripleOfInts.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            int thatRightValue;
            int thatMiddleValue;
            int thatLeftValue;
            int thisLeftValue = Comparator.readInt((byte[])b1, (int)s1);
            if (thisLeftValue < (thatLeftValue = Comparator.readInt((byte[])b2, (int)s2))) {
                return -1;
            }
            if (thisLeftValue > thatLeftValue) {
                return 1;
            }
            int thisMiddleValue = Comparator.readInt((byte[])b1, (int)(s1 + 4));
            if (thisMiddleValue < (thatMiddleValue = Comparator.readInt((byte[])b2, (int)(s2 + 4)))) {
                return -1;
            }
            if (thisMiddleValue > thatMiddleValue) {
                return 1;
            }
            int thisRightValue = Comparator.readInt((byte[])b1, (int)(s1 + 8));
            if (thisRightValue < (thatRightValue = Comparator.readInt((byte[])b2, (int)(s2 + 8)))) {
                return -1;
            }
            if (thisRightValue > thatRightValue) {
                return 1;
            }
            return 0;
        }
    }
}

