/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.mapreduce;

import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NullMapper
extends Mapper<NullWritable, NullWritable, NullWritable, NullWritable> {
    private static final Logger LOG = Logger.getLogger(NullMapper.class);

    public void run(Mapper.Context context) {
        HeartbeatThread t = new HeartbeatThread(context);
        t.start();
        try {
            this.runSafely(context);
        }
        catch (Exception e) {
            t.interrupt();
            throw new RuntimeException(e);
        }
        t.interrupt();
    }

    public abstract void runSafely(Mapper.Context var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HeartbeatThread
    extends Thread {
        private final Mapper.Context context;

        public HeartbeatThread(Mapper.Context context) {
            this.context = context;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    HeartbeatThread.sleep(60000L);
                    LOG.info((Object)"Sending heartbeat...");
                    this.context.getCounter((Enum)HEARTBEAT.BEAT).increment(1L);
                    this.context.setStatus("Sending heartbeat...");
                }
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum HEARTBEAT {
        BEAT;

    }
}

