/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.math;

import com.google.common.base.Preconditions;

public class Gamma {
    private static final double zero = 0.0;
    private static final double one = 1.0;
    private static final double half = 0.5;
    private static final double SQRT2PI = 2.5066282746310002;
    private static final double LN_SQRT2PI = 0.9189385332046728;
    private static final double[] L9 = new double[]{0.9999999999998099, 676.5203681218851, -1259.1392167224028, 771.3234287776531, -176.6150291621406, 12.507343278686905, -0.13857109526572012, 9.984369578019572E-6, 1.5056327351493116E-7};
    private static final double SQRT2PI_E7 = 0.0022857491179850424;
    private static final double[] L15 = new double[]{0.9999999999999971, 57.15623566586292, -59.59796035547549, 14.136097974741746, -0.4919138160976202, 3.399464998481189E-5, 4.652362892704858E-5, -9.837447530487956E-5, 1.580887032249125E-4, -2.1026444172410488E-4, 2.1743961811521265E-4, -1.643181065367639E-4, 8.441822398385275E-5, -2.6190838401581408E-5, 3.6899182659531625E-6};
    private static final double G_PLUS_HALF = 5.2421875;
    private static final double SC1 = 0.08333333333333333;
    private static final double SC2 = 0.003472222222222222;
    private static final double SC3 = -0.0026813271604938273;
    private static final double SC4 = -2.2947209362139917E-4;
    private static final double LC1 = 0.08333333333333333;
    private static final double LC2 = -0.002777777777777778;
    private static final double LC3 = 7.936507936507937E-4;
    private static final double LC4 = -5.952380952380953E-4;
    static final double[] FACT = new double[]{1.0, 40320.0, 2.0922789888E13, 6.204484017332394E23, 2.631308369336935E35, 8.159152832478977E47, 1.2413915592536073E61, 7.109985878048635E74, 1.2688693218588417E89, 6.1234458376886085E103, 7.156945704626381E118, 1.8548264225739844E134, 9.916779348709496E149, 1.0299016745145628E166, 1.974506857221074E182, 6.689502913449127E198, 3.856204823625804E215, 3.659042881952549E232, 5.5502938327393044E249, 1.3113358856834524E267, 4.7147236359920616E284, 2.5260757449731984E302};
    private static final double a0 = 0.07721566490153287;
    private static final double a1 = 0.3224670334241136;
    private static final double a2 = 0.06735230105312927;
    private static final double a3 = 0.020580808432516733;
    private static final double a4 = 0.007385550860814029;
    private static final double a5 = 0.0028905138367341563;
    private static final double a6 = 0.0011927076318336207;
    private static final double a7 = 5.100697921535113E-4;
    private static final double a8 = 2.2086279071390839E-4;
    private static final double a9 = 1.0801156724758394E-4;
    private static final double a10 = 2.5214456545125733E-5;
    private static final double a11 = 4.4864094961891516E-5;
    private static final double tc = 1.4616321449683622;
    private static final double tf = -0.12148629053584961;
    private static final double tt = -3.638676997039505E-18;
    private static final double t0 = 0.48383612272381005;
    private static final double t1 = -0.1475877229945939;
    private static final double t2 = 0.06462494023913339;
    private static final double t3 = -0.032788541075985965;
    private static final double t4 = 0.01797067508118204;
    private static final double t5 = -0.010314224129834144;
    private static final double t6 = 0.006100538702462913;
    private static final double t7 = -0.0036845201678113826;
    private static final double t8 = 0.0022596478090061247;
    private static final double t9 = -0.0014034646998923284;
    private static final double t10 = 8.81081882437654E-4;
    private static final double t11 = -5.385953053567405E-4;
    private static final double t12 = 3.1563207090362595E-4;
    private static final double t13 = -3.1275416837512086E-4;
    private static final double t14 = 3.355291926355191E-4;
    private static final double u0 = -0.07721566490153287;
    private static final double u1 = 0.6328270640250934;
    private static final double u2 = 1.4549225013723477;
    private static final double u3 = 0.9777175279633727;
    private static final double u4 = 0.22896372806469245;
    private static final double u5 = 0.013381091853678766;
    private static final double v1 = 2.4559779371304113;
    private static final double v2 = 2.128489763798934;
    private static final double v3 = 0.7692851504566728;
    private static final double v4 = 0.10422264559336913;
    private static final double v5 = 0.003217092422824239;
    private static final double s0 = -0.07721566490153287;
    private static final double s1 = 0.21498241596060885;
    private static final double s2 = 0.325778796408931;
    private static final double s3 = 0.14635047265246445;
    private static final double s4 = 0.02664227030336386;
    private static final double s5 = 0.0018402845140733772;
    private static final double s6 = 3.194753265841009E-5;
    private static final double r1 = 1.3920053346762105;
    private static final double r2 = 0.7219355475671381;
    private static final double r3 = 0.17193386563280308;
    private static final double r4 = 0.01864591917156529;
    private static final double r5 = 7.779424963818936E-4;
    private static final double r6 = 7.326684307446256E-6;
    private static final double w0 = 0.4189385332046727;
    private static final double w1 = 0.08333333333333297;
    private static final double w2 = -0.0027777777772877554;
    private static final double w3 = 7.936505586430196E-4;
    private static final double w4 = -5.9518755745034E-4;
    private static final double w5 = 8.363399189962821E-4;
    private static final double w6 = -0.0016309293409657527;

    private static String ulps(double v, double ref) {
        double ulp = ref == 0.0 ? Math.ulp(0.1) : Math.ulp(ref);
        int ulps = (int)Math.floor((v - ref) / ulp + 0.5);
        return "" + ulps;
    }

    public static void main(String[] argv) {
        double d;
        double c;
        double e;
        double b;
        for (int i = 1; i < 171; ++i) {
            double a = Math.log(Gamma.factorial(i));
            b = Gamma.lgamma(i + 1);
            e = Gamma.lanczosLGamma15(i);
            c = Gamma.f(i);
            d = Gamma.stirlingLGamma(i);
            System.out.printf("%3d | %6s | %6s | %6s | %6s |\n", i, Gamma.ulps(b, a), Gamma.ulps(e, a), Gamma.ulps(c, a), i >= 10 ? Gamma.ulps(d, a) : "-1000+");
        }
        boolean doBenchmark = true;
        if (doBenchmark) {
            int i;
            int r;
            int N = 20000;
            long t1 = System.currentTimeMillis();
            for (r = 0; r < 20000; ++r) {
                for (i = 1; i < 171; ++i) {
                    b = Gamma.lgamma(i + 1);
                }
            }
            long t2 = System.currentTimeMillis();
            System.out.println("fdlibm's  : " + (t2 - t1));
            t1 = System.currentTimeMillis();
            for (r = 0; r < 20000; ++r) {
                for (i = 1; i < 171; ++i) {
                    e = Gamma.lanczosLGamma15(i);
                }
            }
            t2 = System.currentTimeMillis();
            System.out.println("Lanczos 15: " + (t2 - t1));
            t1 = System.currentTimeMillis();
            for (r = 0; r < 20000; ++r) {
                for (i = 1; i < 171; ++i) {
                    c = Gamma.f(i);
                }
            }
            t2 = System.currentTimeMillis();
            System.out.println("f : " + (t2 - t1));
            t1 = System.currentTimeMillis();
            for (r = 0; r < 20000; ++r) {
                for (i = 1; i < 171; ++i) {
                    d = Gamma.stirlingLGamma(i);
                }
            }
            t2 = System.currentTimeMillis();
            System.out.println("Stirling  :  " + (t2 - t1));
        }
    }

    private static final int HI(double x) {
        return (int)(Double.doubleToLongBits(x) >> 32);
    }

    private static final int LO(double x) {
        return (int)Double.doubleToLongBits(x);
    }

    static final double lanczosGamma9(double x) {
        if (x <= -1.0) {
            return Double.NaN;
        }
        double a = L9[0];
        for (int i = 1; i < 9; ++i) {
            a += L9[i] / (x + (double)i);
        }
        return 0.0022857491179850424 * a * Math.pow((x + 7.5) / Math.E, x + 0.5);
    }

    static final double lanczosLGamma9(double x) {
        if (x <= -1.0) {
            return Double.NaN;
        }
        double a = L9[0];
        for (int i = 1; i < 9; ++i) {
            a += L9[i] / (x + (double)i);
        }
        return 0.9189385332046728 + Math.log(a) - 7.0 + (x + 0.5) * Math.log((x + 7.5) / Math.E);
    }

    static final double lanczosLGamma15(double x) {
        if (x <= -1.0) {
            return Double.NaN;
        }
        double a = L15[0];
        for (int i = 1; i < 15; ++i) {
            a += L15[i] / (x + (double)i);
        }
        double tmp = x + 5.2421875;
        return 0.9189385332046728 + Math.log(a) + (x + 0.5) * Math.log(tmp) - tmp;
    }

    static final double g(double x) {
        if (x <= -1.0) {
            return Double.NaN;
        }
        double tmp = x + 5.2421875;
        return 0.9189385332046728 + Math.log(0.9999999999999971 + 57.15623566586292 / (x + 1.0) + -59.59796035547549 / (x + 2.0) + 14.136097974741746 / (x + 3.0) + -0.4919138160976202 / (x + 4.0) + 3.399464998481189E-5 / (x + 5.0) + 4.652362892704858E-5 / (x + 6.0) + -9.837447530487956E-5 / (x + 7.0) + 1.580887032249125E-4 / (x + 8.0) + -2.1026444172410488E-4 / (x + 9.0) + 2.1743961811521265E-4 / (x + 10.0) + -1.643181065367639E-4 / (x + 11.0) + 8.441822398385275E-5 / (x + 12.0) + -2.6190838401581408E-5 / (x + 13.0) + 3.6899182659531625E-6 / (x + 14.0)) + (x + 0.5) * Math.log(tmp) - tmp;
    }

    static final double f(double x) {
        if (x <= -1.0) {
            return Double.NaN;
        }
        double tmp = x + 5.2421875;
        double d = x + 1.0;
        x = d;
        double d2 = x + 1.0;
        x = d2;
        double d3 = x + 1.0;
        x = d3;
        double d4 = x + 1.0;
        x = d4;
        double d5 = x + 1.0;
        x = d5;
        double d6 = x + 1.0;
        x = d6;
        double d7 = x + 1.0;
        x = d7;
        double d8 = x + 1.0;
        x = d8;
        double d9 = x + 1.0;
        x = d9;
        double d10 = x + 1.0;
        x = d10;
        double d11 = x + 1.0;
        x = d11;
        double d12 = x + 1.0;
        x = d12;
        x = x + 1.0;
        return 0.9189385332046728 + Math.log(0.9999999999999971 + 57.15623566586292 / d + -59.59796035547549 / d2 + 14.136097974741746 / d3 + -0.4919138160976202 / d4 + 3.399464998481189E-5 / d5 + 4.652362892704858E-5 / d6 + -9.837447530487956E-5 / d7 + 1.580887032249125E-4 / d8 + -2.1026444172410488E-4 / d9 + 2.1743961811521265E-4 / d10 + -1.643181065367639E-4 / d11 + 8.441822398385275E-5 / d12 + -2.6190838401581408E-5 / x + 3.6899182659531625E-6 / (x += 1.0)) + (tmp - 4.7421875) * Math.log(tmp) - tmp;
    }

    static final double stirlingGamma(double x) {
        double r1 = 1.0 / x;
        double r2 = r1 * r1;
        double r4 = r2 * r2;
        return 2.5066282746310002 * Math.sqrt(x) * (1.0 + 0.08333333333333333 * r1 + 0.003472222222222222 * r2 + -0.0026813271604938273 * r1 * r2 + -2.2947209362139917E-4 * r4) * Math.pow(x / Math.E, x);
    }

    static final double stirlingLGamma(double x) {
        double r1 = 1.0 / x;
        double r2 = r1 * r1;
        double r3 = r1 * r2;
        double r5 = r2 * r3;
        double r7 = r3 * r3 * r1;
        return (x + 0.5) * Math.log(x) - x + 0.9189385332046728 + 0.08333333333333333 * r1 + -0.002777777777777778 * r3 + 7.936507936507937E-4 * r5 + -5.952380952380953E-4 * r7;
    }

    static final double factorial(double x) {
        if (x <= -1.0) {
            return Double.NaN;
        }
        if (x <= 170.0 && Math.floor(x) == x) {
            int n = (int)x;
            double extra = x;
            switch (n & 7) {
                case 7: {
                    extra *= (x -= 1.0);
                }
                case 6: {
                    extra *= (x -= 1.0);
                }
                case 5: {
                    extra *= (x -= 1.0);
                }
                case 4: {
                    extra *= (x -= 1.0);
                }
                case 3: {
                    extra *= (x -= 1.0);
                }
                case 2: {
                    extra *= (x -= 1.0);
                }
                case 1: {
                    return FACT[n >> 3] * extra;
                }
                case 0: {
                    return FACT[n >> 3];
                }
            }
        }
        return Math.exp(Gamma.lgamma(x + 1.0));
    }

    static final double lgamma(double x) {
        double r;
        int hx = Gamma.HI(x);
        int lx = Gamma.LO(x);
        int ix = hx & Integer.MAX_VALUE;
        if (ix >= 0x7FF00000) {
            return Double.POSITIVE_INFINITY;
        }
        if ((ix | lx) == 0 || hx < 0) {
            return Double.NaN;
        }
        if (ix < 999292928) {
            return -Math.log(x);
        }
        if ((ix - 0x3FF00000 | lx) == 0 || (ix - 0x40000000 | lx) == 0) {
            r = 0.0;
        } else if (ix < 0x40000000) {
            int i;
            double y;
            if (ix <= 1072483532) {
                r = -Math.log(x);
                if (ix >= 1072130372) {
                    y = 1.0 - x;
                    i = 0;
                } else if (ix >= 1070442081) {
                    y = x - 0.46163214496836225;
                    i = 1;
                } else {
                    y = x;
                    i = 2;
                }
            } else {
                r = 0.0;
                if (ix >= 1073460419) {
                    y = 2.0 - x;
                    i = 0;
                } else if (ix >= 1072936132) {
                    y = x - 1.4616321449683622;
                    i = 1;
                } else {
                    y = x - 1.0;
                    i = 2;
                }
            }
            switch (i) {
                case 0: {
                    double z = y * y;
                    double p1 = 0.07721566490153287 + z * (0.06735230105312927 + z * (0.007385550860814029 + z * (0.0011927076318336207 + z * (2.2086279071390839E-4 + z * 2.5214456545125733E-5))));
                    double p2 = z * (0.3224670334241136 + z * (0.020580808432516733 + z * (0.0028905138367341563 + z * (5.100697921535113E-4 + z * (1.0801156724758394E-4 + z * 4.4864094961891516E-5)))));
                    double p = y * p1 + p2;
                    r += p - 0.5 * y;
                    break;
                }
                case 1: {
                    double z = y * y;
                    double w = z * y;
                    double p1 = 0.48383612272381005 + w * (-0.032788541075985965 + w * (0.006100538702462913 + w * (-0.0014034646998923284 + w * 3.1563207090362595E-4)));
                    double p2 = -0.1475877229945939 + w * (0.01797067508118204 + w * (-0.0036845201678113826 + w * (8.81081882437654E-4 + w * -3.1275416837512086E-4)));
                    double p3 = 0.06462494023913339 + w * (-0.010314224129834144 + w * (0.0022596478090061247 + w * (-5.385953053567405E-4 + w * 3.355291926355191E-4)));
                    double p = z * p1 - (-3.638676997039505E-18 - w * (p2 + y * p3));
                    r += -0.12148629053584961 + p;
                    break;
                }
                case 2: {
                    double p1 = y * (-0.07721566490153287 + y * (0.6328270640250934 + y * (1.4549225013723477 + y * (0.9777175279633727 + y * (0.22896372806469245 + y * 0.013381091853678766)))));
                    double p2 = 1.0 + y * (2.4559779371304113 + y * (2.128489763798934 + y * (0.7692851504566728 + y * (0.10422264559336913 + y * 0.003217092422824239))));
                    r += -0.5 * y + p1 / p2;
                }
            }
        } else if (ix < 0x40200000) {
            int i = (int)x;
            double t = 0.0;
            double y = x - (double)i;
            double p = y * (-0.07721566490153287 + y * (0.21498241596060885 + y * (0.325778796408931 + y * (0.14635047265246445 + y * (0.02664227030336386 + y * (0.0018402845140733772 + y * 3.194753265841009E-5))))));
            double q = 1.0 + y * (1.3920053346762105 + y * (0.7219355475671381 + y * (0.17193386563280308 + y * (0.01864591917156529 + y * (7.779424963818936E-4 + y * 7.326684307446256E-6)))));
            r = 0.5 * y + p / q;
            double z = 1.0;
            switch (i) {
                case 7: {
                    z *= y + 6.0;
                }
                case 6: {
                    z *= y + 5.0;
                }
                case 5: {
                    z *= y + 4.0;
                }
                case 4: {
                    z *= y + 3.0;
                }
                case 3: {
                    r += Math.log(z *= y + 2.0);
                }
            }
        } else if (ix < 1133510656) {
            double t = Math.log(x);
            double z = 1.0 / x;
            double y = z * z;
            double w = 0.4189385332046727 + z * (0.08333333333333297 + y * (-0.0027777777772877554 + y * (7.936505586430196E-4 + y * (-5.9518755745034E-4 + y * (8.363399189962821E-4 + y * -0.0016309293409657527)))));
            r = (x - 0.5) * (t - 1.0) + w;
        } else {
            r = x * (Math.log(x) - 1.0);
        }
        return r;
    }

    public static double digamma(double x) {
        double r = 0.0;
        while (x <= 5.0) {
            r -= 1.0 / x;
            x += 1.0;
        }
        double f = 1.0 / (x * x);
        double t = f * (-0.08333333333333333 + f * (0.008333333333333333 + f * (-0.003968253968253968 + f * (0.004166666666666667 + f * (-0.007575757575757576 + f * (0.0210927960928 + f * (-0.08333333333333333 + f * 0.44325980392157)))))));
        return r + Math.log(x) - 0.5 / x + t;
    }

    public static double trigamma(double x) {
        double p = 1.0 / ((x += 6.0) * x);
        p = (((((0.075757575757576 * p - 0.033333333333333) * p + 0.0238095238095238) * p - 0.033333333333333) * p + 0.166666666666667) * p + 1.0) / x + 0.5 * p;
        for (int i = 0; i < 6; ++i) {
            p = 1.0 / ((x -= 1.0) * x) + p;
        }
        Preconditions.checkArgument((!Double.isNaN(p) ? 1 : 0) != 0, (Object)new ArithmeticException("invalid input at trigamma function: " + x));
        if (Double.isNaN(p)) {
            throw new ArithmeticException("invalid input at trigamma function: " + x);
        }
        return p;
    }

    public static double lngamma(double x) {
        return Gamma.lgamma(x);
    }

    public static double logGamma(double x) {
        double z = 1.0 / (x * x);
        z = (((-5.95238095238E-4 * z + 7.93650793651E-4) * z - 0.002777777777778) * z + 0.083333333333333) / (x += 6.0);
        z = (x - 0.5) * Math.log(x) - x + 0.918938533204673 + z - Math.log(x - 1.0) - Math.log(x - 2.0) - Math.log(x - 3.0) - Math.log(x - 4.0) - Math.log(x - 5.0) - Math.log(x - 6.0);
        if (new Double(z).equals(Double.NaN)) {
            throw new ArithmeticException("invalid input at lnGamma function: " + x);
        }
        return z;
    }
}

