/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.webgraph;

import edu.umd.cloud9.util.PowerTool;
import edu.umd.cloud9.webgraph.data.AnchorText;
import edu.umd.cloud9.webgraph.data.AnchorTextConstants;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.log4j.Logger;
import tl.lin.data.array.ArrayListOfInts;
import tl.lin.data.array.ArrayListWritable;

public class BuildReverseWebGraph
extends PowerTool {
    private static final Logger LOG = Logger.getLogger(BuildReverseWebGraph.class);
    public static final String[] RequiredParameters = new String[]{"Cloud9.InputPath", "Cloud9.OutputPath", "Cloud9.Mappers", "Cloud9.Reducers"};

    public String[] getRequiredParameters() {
        return RequiredParameters;
    }

    public BuildReverseWebGraph(Configuration conf) {
        super(conf);
    }

    public int runTool() throws Exception {
        JobConf conf = new JobConf(this.getConf(), BuildReverseWebGraph.class);
        FileSystem fs = FileSystem.get((Configuration)conf);
        int numMappers = conf.getInt("Cloud9.Mappers", 1);
        int numReducers = conf.getInt("Cloud9.Reducers", 200);
        String inputPath = conf.get("Cloud9.InputPath");
        String outputPath = conf.get("Cloud9.OutputPath");
        conf.setJobName("ReverseWebGraph");
        conf.set("mapred.child.java.opts", "-Xmx2048m");
        conf.setInt("mapred.task.timeout", 60000000);
        conf.set("mapreduce.map.memory.mb", "2048");
        conf.set("mapreduce.map.java.opts", "-Xmx2048m");
        conf.set("mapreduce.reduce.memory.mb", "2048");
        conf.set("mapreduce.reduce.java.opts", "-Xmx2048m");
        conf.set("mapreduce.task.timeout", "60000000");
        conf.setNumMapTasks(numMappers);
        conf.setNumReduceTasks(numReducers);
        conf.setMapperClass(IdentityMapper.class);
        conf.setReducerClass(Reduce.class);
        conf.setOutputKeyClass(IntWritable.class);
        conf.setOutputValueClass(ArrayListWritable.class);
        conf.setMapOutputKeyClass(Text.class);
        conf.setMapOutputValueClass(ArrayListWritable.class);
        conf.setInputFormat(SequenceFileInputFormat.class);
        conf.setOutputFormat(SequenceFileOutputFormat.class);
        SequenceFileOutputFormat.setCompressOutput((JobConf)conf, (boolean)true);
        SequenceFileOutputFormat.setOutputCompressionType((JobConf)conf, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK);
        SequenceFileInputFormat.setInputPaths((JobConf)conf, (String)inputPath);
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)new Path(outputPath));
        LOG.info((Object)"BuildReverseWebGraph");
        LOG.info((Object)(" - input path: " + inputPath));
        LOG.info((Object)(" - output path: " + outputPath));
        if (!fs.exists(new Path(outputPath))) {
            JobClient.runJob((JobConf)conf);
        } else {
            LOG.info((Object)(outputPath + " already exists! Skipping this step..."));
        }
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Reduce
    extends MapReduceBase
    implements Reducer<Text, ArrayListWritable<AnchorText>, IntWritable, ArrayListWritable<AnchorText>> {
        private static final IntWritable keyWord = new IntWritable();
        private static final ArrayListWritable<AnchorText> arrayList = new ArrayListWritable();
        private static final ArrayListOfInts docnos = new ArrayListOfInts();
        private static ArrayListWritable<AnchorText> packet;
        private static boolean pushed;
        private int indegree;

        public void reduce(Text key, Iterator<ArrayListWritable<AnchorText>> values, OutputCollector<IntWritable, ArrayListWritable<AnchorText>> output, Reporter reporter) throws IOException {
            docnos.clear();
            arrayList.clear();
            this.indegree = 0;
            while (values.hasNext()) {
                packet = values.next();
                for (AnchorText data : packet) {
                    if (data.isDocnoField()) {
                        for (int docno : data) {
                            docnos.add(docno);
                        }
                        continue;
                    }
                    pushed = false;
                    this.indegree += data.getSize();
                    for (int i = 0; i < arrayList.size(); ++i) {
                        if (!((AnchorText)arrayList.get(i)).equalsIgnoreSources(data)) continue;
                        ((AnchorText)arrayList.get(i)).addDocumentsFrom(data);
                        pushed = true;
                        break;
                    }
                    if (pushed) continue;
                    arrayList.add((Object)data.clone());
                }
            }
            arrayList.add((Object)new AnchorText(AnchorTextConstants.Type.IN_DEGREE.val, null, this.indegree));
            arrayList.add((Object)new AnchorText(AnchorTextConstants.Type.URL_FIELD.val, key.toString()));
            Collections.sort(arrayList);
            Iterator i$ = docnos.iterator();
            while (i$.hasNext()) {
                int docno = (Integer)i$.next();
                keyWord.set(docno);
                output.collect((Object)keyWord, arrayList);
            }
        }
    }
}

