/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.webgraph;

import edu.umd.cloud9.util.PowerTool;
import edu.umd.cloud9.webgraph.data.AnchorText;
import edu.umd.cloud9.webgraph.data.AnchorTextConstants;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Partitioner;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.log4j.Logger;
import tl.lin.data.array.ArrayListWritable;
import tl.lin.data.pair.PairOfIntString;

public class CollectHostnames
extends PowerTool {
    private static final Logger sLogger = Logger.getLogger(CollectHostnames.class);
    public static final String[] RequiredParameters = new String[]{"Cloud9.InputPath", "Cloud9.OutputPath", "Cloud9.Mappers", "Cloud9.Reducers"};

    public String[] getRequiredParameters() {
        return RequiredParameters;
    }

    public CollectHostnames(Configuration conf) {
        super(conf);
    }

    public int runTool() throws Exception {
        JobConf conf = new JobConf(this.getConf(), CollectHostnames.class);
        FileSystem fs = FileSystem.get((Configuration)conf);
        int numMappers = conf.getInt("Cloud9.Mappers", 1);
        int numReducers = conf.getInt("Cloud9.Reducers", 200);
        String inputPath = conf.get("Cloud9.InputPath");
        String outputPath = conf.get("Cloud9.OutputPath");
        conf.setJobName("CollectHostnames");
        conf.set("mapred.child.java.opts", "-Xmx4096m");
        conf.setInt("mapred.task.timeout", 60000000);
        conf.setNumMapTasks(numMappers);
        conf.setNumReduceTasks(numReducers);
        conf.setMapperClass(Map.class);
        conf.setPartitionerClass(Partition.class);
        conf.setReducerClass(Reduce.class);
        conf.setOutputKeyClass(IntWritable.class);
        conf.setOutputValueClass(ArrayListWritable.class);
        conf.setMapOutputKeyClass(PairOfIntString.class);
        conf.setMapOutputValueClass(IntWritable.class);
        conf.setInputFormat(SequenceFileInputFormat.class);
        conf.setOutputFormat(SequenceFileOutputFormat.class);
        SequenceFileOutputFormat.setCompressOutput((JobConf)conf, (boolean)true);
        SequenceFileOutputFormat.setOutputCompressionType((JobConf)conf, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK);
        SequenceFileInputFormat.setInputPaths((JobConf)conf, (String)inputPath);
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)new Path(outputPath));
        sLogger.info((Object)"PropagateHostname");
        sLogger.info((Object)(" - input path: " + inputPath));
        sLogger.info((Object)(" - output path: " + outputPath));
        if (!fs.exists(new Path(outputPath))) {
            JobClient.runJob((JobConf)conf);
        } else {
            sLogger.info((Object)(outputPath + " already exists! Skipping this step..."));
        }
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Reduce
    extends MapReduceBase
    implements Reducer<PairOfIntString, IntWritable, IntWritable, ArrayListWritable<AnchorText>> {
        private static OutputCollector<IntWritable, ArrayListWritable<AnchorText>> outputCollector;
        private static final ArrayListWritable<AnchorText> arrayList;
        private static final IntWritable keyWord;
        private static boolean firstTime;
        private static int currentDocument;
        private static int packet;

        public void reduce(PairOfIntString key, Iterator<IntWritable> values, OutputCollector<IntWritable, ArrayListWritable<AnchorText>> output, Reporter reporter) throws IOException {
            if (firstTime) {
                outputCollector = output;
                firstTime = false;
                arrayList.clear();
                currentDocument = key.getLeftElement();
            } else if (currentDocument != key.getLeftElement()) {
                Collections.sort(arrayList);
                keyWord.set(currentDocument);
                output.collect((Object)keyWord, arrayList);
                currentDocument = key.getLeftElement();
                arrayList.clear();
            }
            arrayList.add((Object)new AnchorText(AnchorTextConstants.Type.OTHER_TYPES.val, key.getRightElement()));
            int currentIndex = arrayList.size() - 1;
            while (values.hasNext()) {
                packet = values.next().get();
                if (((AnchorText)arrayList.get(currentIndex)).getSize() < 0x100000) {
                    ((AnchorText)arrayList.get(currentIndex)).addDocument(packet);
                    continue;
                }
                arrayList.add((Object)new AnchorText(AnchorTextConstants.Type.OTHER_TYPES.val, key.getRightElement(), packet));
                currentIndex = arrayList.size() - 1;
            }
        }

        public void close() throws IOException {
            Collections.sort(arrayList);
            keyWord.set(currentDocument);
            outputCollector.collect((Object)keyWord, arrayList);
        }

        static {
            arrayList = new ArrayListWritable();
            keyWord = new IntWritable();
            firstTime = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Partition
    implements Partitioner<PairOfIntString, IntWritable> {
        protected Partition() {
        }

        public void configure(JobConf job) {
        }

        public int getPartition(PairOfIntString key, IntWritable value, int numReduceTasks) {
            return Math.abs(key.getLeftElement() % numReduceTasks);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Map
    extends MapReduceBase
    implements Mapper<IntWritable, ArrayListWritable<AnchorText>, PairOfIntString, IntWritable> {
        private static final PairOfIntString keyWord = new PairOfIntString();
        private static final IntWritable valueWord = new IntWritable();
        private static String host;

        public void map(IntWritable key, ArrayListWritable<AnchorText> anchors, OutputCollector<PairOfIntString, IntWritable> output, Reporter reporter) throws IOException {
            for (AnchorText data : anchors) {
                if (!data.isURL()) continue;
                try {
                    host = new URI(data.getText()).getHost();
                }
                catch (Exception e) {
                    return;
                }
            }
            for (AnchorText data : anchors) {
                if (!data.isExternalOutLink()) continue;
                valueWord.set(key.get());
                for (int target : data) {
                    keyWord.set(target, host);
                    output.collect((Object)keyWord, (Object)valueWord);
                }
            }
        }
    }
}

