/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.webgraph;

import edu.umd.cloud9.util.PowerTool;
import edu.umd.cloud9.webgraph.data.AnchorText;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Partitioner;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.log4j.Logger;
import tl.lin.data.array.ArrayListWritable;
import tl.lin.data.pair.PairOfInts;

public class ComputeWeight
extends PowerTool {
    private static final Logger LOG = Logger.getLogger(ComputeWeight.class);
    private static final int HOSTMAP = 1;
    private static final int DATA = 0;
    public static final String[] RequiredParameters = new String[]{"Cloud9.InputPath", "Cloud9.OutputPath", "Cloud9.Mappers", "Cloud9.Reducers"};

    public String[] getRequiredParameters() {
        return RequiredParameters;
    }

    public ComputeWeight(Configuration conf) {
        super(conf);
    }

    public int runTool() throws Exception {
        JobConf conf = new JobConf(this.getConf(), ComputeWeight.class);
        FileSystem fs = FileSystem.get((Configuration)conf);
        int numMappers = conf.getInt("Cloud9.Mappers", 1);
        int numReducers = conf.getInt("Cloud9.Reducers", 200);
        String inputPath = conf.get("Cloud9.InputPath");
        String outputPath = conf.get("Cloud9.OutputPath");
        conf.setJobName("ComputeWeights");
        conf.set("mapred.child.java.opts", "-Xmx4096m");
        conf.setInt("mapred.task.timeout", 60000000);
        conf.setNumMapTasks(numMappers);
        conf.setNumReduceTasks(numReducers);
        conf.setMapperClass(Map.class);
        conf.setPartitionerClass(Partition.class);
        conf.setReducerClass(Reduce.class);
        conf.setOutputKeyClass(IntWritable.class);
        conf.setOutputValueClass(ArrayListWritable.class);
        conf.setMapOutputKeyClass(PairOfInts.class);
        conf.setMapOutputValueClass(ArrayListWritable.class);
        conf.setInputFormat(SequenceFileInputFormat.class);
        conf.setOutputFormat(SequenceFileOutputFormat.class);
        SequenceFileOutputFormat.setCompressOutput((JobConf)conf, (boolean)true);
        SequenceFileOutputFormat.setOutputCompressionType((JobConf)conf, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK);
        SequenceFileInputFormat.setInputPaths((JobConf)conf, (String)inputPath);
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)new Path(outputPath));
        LOG.info((Object)"ComputeWeight");
        LOG.info((Object)(" - input path: " + inputPath));
        LOG.info((Object)(" - output path: " + outputPath));
        if (!fs.exists(new Path(outputPath))) {
            JobClient.runJob((JobConf)conf);
        } else {
            LOG.info((Object)(outputPath + " already exists! Skipping this step..."));
        }
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Reduce
    extends MapReduceBase
    implements Reducer<PairOfInts, ArrayListWritable<AnchorText>, IntWritable, ArrayListWritable<AnchorText>> {
        private static OutputCollector<IntWritable, ArrayListWritable<AnchorText>> outputCollector;
        private static final ArrayListWritable<AnchorText> arrayList;
        private static final IntWritable keyWord;
        private static ArrayListWritable<AnchorText> packet;
        private static int currentDocument;
        private static int linkCounter;
        private static boolean firstTime;
        private static String lastHost;
        private static HashSet<Integer> intersects;
        private static int[] simMap;

        public void reduce(PairOfInts key, Iterator<ArrayListWritable<AnchorText>> values, OutputCollector<IntWritable, ArrayListWritable<AnchorText>> output, Reporter reporter) throws IOException {
            if (key.getRightElement() == 0) {
                if (!firstTime) {
                    keyWord.set(currentDocument);
                    output.collect((Object)keyWord, arrayList);
                } else {
                    firstTime = false;
                    outputCollector = output;
                }
                currentDocument = key.getLeftElement();
                arrayList.clear();
                while (values.hasNext()) {
                    packet = values.next();
                    arrayList.ensureCapacity(packet.size());
                    for (AnchorText data : packet) {
                        arrayList.add((Object)data);
                    }
                }
            } else {
                linkCounter = 0;
                simMap = new int[arrayList.size()];
                for (int i = 1; i < arrayList.size(); ++i) {
                    if (((AnchorText)arrayList.get(i)).equalsIgnoreSources((AnchorText)arrayList.get(i - 1))) {
                        Reduce.simMap[i] = simMap[i - 1];
                        continue;
                    }
                    Reduce.simMap[i] = i;
                    if (!((AnchorText)arrayList.get(i)).isExternalInLink()) continue;
                    ++linkCounter;
                }
                lastHost = "";
                intersects.clear();
                while (values.hasNext()) {
                    packet = values.next();
                    for (AnchorText data : packet) {
                        int i;
                        if (!data.getText().equals(lastHost)) {
                            if (intersects.size() > 0) {
                                for (i = 0; i < simMap.length; ++i) {
                                    if (!intersects.contains(simMap[i])) continue;
                                    ((AnchorText)arrayList.get(i)).setWeight(((AnchorText)arrayList.get(i)).getWeight() + 1.0f / (float)intersects.size());
                                }
                            }
                            intersects.clear();
                        }
                        lastHost = data.getText();
                        for (i = 0; i < arrayList.size(); ++i) {
                            if (!((AnchorText)arrayList.get(i)).isExternalInLink() || intersects.contains(simMap[i])) continue;
                            if (linkCounter == 1) {
                                intersects.add(simMap[i]);
                                continue;
                            }
                            if (!data.intersects((AnchorText)arrayList.get(i))) continue;
                            intersects.add(simMap[i]);
                        }
                    }
                }
                if (intersects.size() > 0) {
                    for (int i = 0; i < simMap.length; ++i) {
                        if (!intersects.contains(simMap[i])) continue;
                        ((AnchorText)arrayList.get(i)).setWeight(((AnchorText)arrayList.get(i)).getWeight() + 1.0f / (float)intersects.size());
                    }
                }
                intersects.clear();
            }
        }

        public void close() throws IOException {
            keyWord.set(currentDocument);
            outputCollector.collect((Object)keyWord, arrayList);
        }

        static {
            arrayList = new ArrayListWritable();
            keyWord = new IntWritable();
            firstTime = true;
            intersects = new HashSet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Partition
    implements Partitioner<PairOfInts, ArrayListWritable<AnchorText>> {
        protected Partition() {
        }

        public void configure(JobConf job) {
        }

        public int getPartition(PairOfInts key, ArrayListWritable<AnchorText> value, int numReduceTasks) {
            return Math.abs(key.getLeftElement() % numReduceTasks);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Map
    extends MapReduceBase
    implements Mapper<IntWritable, ArrayListWritable<AnchorText>, PairOfInts, ArrayListWritable<AnchorText>> {
        private static final ArrayListWritable<AnchorText> arrayList = new ArrayListWritable();
        private static final PairOfInts keyWord = new PairOfInts();

        public void map(IntWritable key, ArrayListWritable<AnchorText> anchors, OutputCollector<PairOfInts, ArrayListWritable<AnchorText>> output, Reporter reporter) throws IOException {
            if (anchors.size() == 0) {
                return;
            }
            if (!((AnchorText)anchors.get(0)).isOfOtherTypes()) {
                keyWord.set(key.get(), 0);
                output.collect((Object)keyWord, anchors);
                return;
            }
            keyWord.set(key.get(), 1);
            for (AnchorText data : anchors) {
                arrayList.clear();
                arrayList.add((Object)data);
                output.collect((Object)keyWord, arrayList);
            }
        }
    }
}

