/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.webgraph.data;

import edu.umd.cloud9.webgraph.data.AnchorTextConstants;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.io.WritableComparable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnchorText
implements WritableComparable<AnchorText>,
AnchorTextConstants,
Iterable<Integer> {
    private byte type;
    private String text;
    private IntOpenHashSet documentList = new IntOpenHashSet();
    private float weight;

    public AnchorText() {
        this.resetToType(AnchorTextConstants.Type.INTERNAL_IN_LINK.val);
    }

    public AnchorText(byte type, String text) {
        this();
        this.resetToType(type);
        this.setText(text);
    }

    public AnchorText(byte type, String text, int docno) {
        this();
        this.resetToType(type);
        this.setText(text);
        if (this.hasValidDocumentList()) {
            this.addDocument(docno);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.type = in.readByte();
        this.resetToType(this.type);
        if (this.hasValidText()) {
            this.text = in.readUTF();
        }
        if (this.hasValidDocumentList()) {
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                this.documentList.add(in.readInt());
            }
        }
        if (this.hasValidWeight()) {
            this.weight = in.readFloat();
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(this.type);
        if (this.hasValidText()) {
            out.writeUTF(this.text);
        }
        if (this.hasValidDocumentList()) {
            out.writeInt(this.documentList.size());
            IntIterator iterator = this.documentList.iterator();
            while (iterator.hasNext()) {
                out.writeInt((Integer)iterator.next());
            }
        }
        if (this.hasValidWeight()) {
            out.writeFloat(this.weight);
        }
    }

    public byte getType() {
        return this.type;
    }

    public void resetToType(byte type) {
        this.type = type;
        this.text = this.hasValidText() ? "" : null;
        this.weight = 0.0f;
        this.documentList.clear();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        if (this.hasValidText()) {
            this.text = text;
        }
    }

    public float getWeight() {
        return this.weight;
    }

    public void setWeight(float weight) {
        if (this.isExternalInLink()) {
            this.weight = weight;
            this.type = AnchorTextConstants.Type.WEIGHTED_EXTERNAL_IN_LINK.val;
        }
    }

    public int getSize() {
        return this.documentList.size();
    }

    public int[] getDocuments() {
        return this.documentList.toIntArray();
    }

    public void addDocument(int docno) {
        if (!this.hasValidDocumentList()) {
            return;
        }
        this.documentList.add(docno);
    }

    public void addDocumentsFrom(AnchorText other) {
        if (!this.hasValidDocumentList()) {
            return;
        }
        IntIterator iterator = other.documentList.iterator();
        while (iterator.hasNext()) {
            this.addDocument((Integer)iterator.next());
        }
    }

    public boolean containsDocument(int docno) {
        if (!this.hasValidDocumentList()) {
            return false;
        }
        return this.documentList.contains(docno);
    }

    public boolean intersects(AnchorText other) {
        if (!this.hasValidDocumentList() || !other.hasValidDocumentList()) {
            return false;
        }
        if (this.getSize() < other.getSize()) {
            IntIterator iterator = this.documentList.iterator();
            while (iterator.hasNext()) {
                if (!other.containsDocument((Integer)iterator.next())) continue;
                return true;
            }
        } else {
            IntIterator iterator = other.documentList.iterator();
            while (iterator.hasNext()) {
                if (!this.documentList.contains(iterator.next())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equalsIgnoreSources(AnchorText other) {
        if (this.type != other.getType()) {
            return false;
        }
        if (this.hasValidWeight() && this.weight != other.getWeight()) {
            return false;
        }
        if (this.hasValidText()) {
            return this.text.equals(other.getText());
        }
        return true;
    }

    public boolean equals(Object obj) {
        AnchorText other = (AnchorText)obj;
        if (this.hasValidDocumentList() && other.hasValidDocumentList()) {
            if (this.documentList.size() != other.documentList.size()) {
                return false;
            }
            IntIterator iterator = this.documentList.iterator();
            while (iterator.hasNext()) {
                if (other.containsDocument((Integer)iterator.next())) continue;
                return false;
            }
        }
        return this.equalsIgnoreSources(other);
    }

    public int compareTo(AnchorText obj) {
        byte fl = obj.getType();
        String text = obj.getText();
        if (this.type != fl) {
            return this.type < fl ? -1 : 1;
        }
        if (this.hasValidText()) {
            return this.text.compareTo(text);
        }
        return 0;
    }

    public int hashCode() {
        if (this.hasValidText()) {
            return this.text.hashCode() + this.type;
        }
        return this.type;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        if (this.isExternalInLink()) {
            builder.append("ExternalInLink");
        } else if (this.isInternalInLink()) {
            builder.append("InternalInLink");
        } else if (this.isExternalOutLink()) {
            builder.append("ExternalOutLink");
        } else if (this.isInternalOutLink()) {
            builder.append("InternalOutLink");
        } else if (this.isDocnoField()) {
            builder.append("Docno");
        } else if (this.isURL()) {
            builder.append("URL");
        } else if (this.isInDegree()) {
            builder.append("Indegree");
        } else if (this.isOutDegree()) {
            builder.append("Outdegree");
        } else {
            builder.append("OtherType");
        }
        if (this.hasValidText()) {
            builder.append(", " + this.text);
        }
        if (this.hasValidDocumentList()) {
            builder.append(", " + this.documentList.toString());
        }
        if (this.hasValidWeight()) {
            builder.append(", w:" + this.weight);
        }
        builder.append(")");
        return builder.toString();
    }

    public AnchorText clone() {
        AnchorText cloned = new AnchorText();
        cloned.resetToType(this.type);
        cloned.setText(this.text);
        if (this.hasValidDocumentList()) {
            cloned.addDocumentsFrom(this);
        }
        if (this.hasValidWeight()) {
            cloned.weight = this.weight;
        }
        return cloned;
    }

    public boolean isExternalInLink() {
        return this.type == AnchorTextConstants.Type.EXTERNAL_IN_LINK.val || this.type == AnchorTextConstants.Type.WEIGHTED_EXTERNAL_IN_LINK.val;
    }

    public boolean isInternalInLink() {
        return this.type == AnchorTextConstants.Type.INTERNAL_IN_LINK.val;
    }

    public boolean isExternalOutLink() {
        return this.type == AnchorTextConstants.Type.EXTERNAL_OUT_LINK.val;
    }

    public boolean isInternalOutLink() {
        return this.type == AnchorTextConstants.Type.INTERNAL_OUT_LINK.val;
    }

    public boolean isWeighted() {
        return this.type == AnchorTextConstants.Type.WEIGHTED_EXTERNAL_IN_LINK.val;
    }

    public boolean isInDegree() {
        return this.type == AnchorTextConstants.Type.IN_DEGREE.val;
    }

    public boolean isOutDegree() {
        return this.type == AnchorTextConstants.Type.OUT_DEGREE.val;
    }

    public boolean isDocnoField() {
        return this.type == AnchorTextConstants.Type.DOCNO_FIELD.val;
    }

    public boolean isURL() {
        return this.type == AnchorTextConstants.Type.URL_FIELD.val;
    }

    public boolean isOfOtherTypes() {
        return this.type == AnchorTextConstants.Type.OTHER_TYPES.val;
    }

    public boolean hasValidText() {
        return this.type == AnchorTextConstants.Type.EXTERNAL_IN_LINK.val || this.type == AnchorTextConstants.Type.INTERNAL_IN_LINK.val || this.type == AnchorTextConstants.Type.URL_FIELD.val || this.type == AnchorTextConstants.Type.OTHER_TYPES.val || this.type == AnchorTextConstants.Type.WEIGHTED_EXTERNAL_IN_LINK.val;
    }

    private boolean hasValidDocumentList() {
        return this.type != AnchorTextConstants.Type.URL_FIELD.val;
    }

    private boolean hasValidWeight() {
        return this.type == AnchorTextConstants.Type.WEIGHTED_EXTERNAL_IN_LINK.val;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            IntIterator iterator;
            {
                this.iterator = AnchorText.this.documentList.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Integer next() {
                return (Integer)this.iterator.next();
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        };
    }
}

