/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.webgraph.data;

import com.google.common.base.Preconditions;
import edu.umd.cloud9.collection.Indexable;
import edu.umd.cloud9.webgraph.data.AnchorText;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tl.lin.data.array.ArrayListWritable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexableAnchorText
extends Indexable {
    private static final int DEFAULT_MAX_CONTENT_LENGTH = 0x100000;
    private StringBuilder content;
    private boolean hasDocid = false;
    private String docid = null;

    public IndexableAnchorText() {
        this.content = new StringBuilder();
        this.hasDocid = false;
        this.docid = null;
    }

    public IndexableAnchorText(String docid, ArrayListWritable<AnchorText> anchors) {
        this.setDocid(docid);
        this.concatenateAnchors(anchors, 0x100000);
    }

    public IndexableAnchorText(String docid, ArrayListWritable<AnchorText> anchors, int maxContentLength) {
        this.setDocid(docid);
        this.concatenateAnchors(anchors, maxContentLength);
    }

    public void clear() {
        this.content.delete(0, this.content.length());
        this.hasDocid = false;
        this.docid = null;
    }

    public void setDocid(String docid) {
        if (docid != null) {
            this.docid = docid;
            this.hasDocid = true;
        }
    }

    public void concatenateAnchors(ArrayListWritable<AnchorText> anchors) {
        this.concatenateAnchors(anchors, 0x100000);
    }

    public void concatenateAnchors(ArrayListWritable<AnchorText> anchors, int maxContentLength) {
        Preconditions.checkNotNull(anchors);
        this.content.delete(0, this.content.length());
        Collections.sort(anchors, new AnchorWeightComparator());
        String previous = "";
        for (AnchorText anchor : anchors) {
            if (!anchor.isExternalInLink()) continue;
            String anchorText = anchor.getText();
            if (this.content.length() + anchorText.length() > maxContentLength) break;
            if (previous.equals(anchorText)) continue;
            this.content.append(anchorText + " ");
            previous = anchorText;
        }
    }

    public void createHTML(ArrayListWritable<AnchorText> anchors) {
        this.content.delete(0, this.content.length());
        String url = "";
        for (AnchorText anchor : anchors) {
            if (!anchor.isURL()) continue;
            url = anchor.getText();
        }
        this.content.append("<html><head><title>" + url + "</title></head><body> Incoming Links:<br />");
        for (AnchorText anchor : anchors) {
            if (!anchor.isExternalInLink() && !anchor.isInternalInLink()) continue;
            this.content.append(anchor.toString() + "<br />");
        }
        this.content.append("<br />Outgoing Links: <br />");
        for (AnchorText anchor : anchors) {
            if (!anchor.isExternalOutLink() && !anchor.isInternalOutLink()) continue;
            this.content.append(anchor.toString() + "<br />");
        }
        String html = this.content.toString();
        Matcher m = Pattern.compile("[\\[,]([\\d&&[^,\\[\\]]]*)[,\\]]").matcher(this.content.toString());
        int start = 0;
        while (m.find(start)) {
            html = html.replace(m.group(), m.group().charAt(0) + "<a href=\"/fetch_docno?docno=" + m.group(1) + "\">" + m.group(1) + "</a>" + m.group().charAt(m.group().length() - 1));
            start = m.end() - 1;
        }
        this.content.delete(0, this.content.length());
        this.content.append(html);
    }

    @Override
    public String getContent() {
        return this.content.toString().trim();
    }

    @Override
    public String getDisplayContentType() {
        return "text/html";
    }

    @Override
    public String getDocid() {
        return this.docid;
    }

    public String toString() {
        return "Docid: " + this.docid + "\n" + this.content.toString();
    }

    public void readFields(DataInput in) throws IOException {
        this.content.delete(0, this.content.length());
        this.docid = null;
        char[] stream = new char[in.readInt()];
        for (int i = 0; i < stream.length; ++i) {
            stream[i] = in.readChar();
        }
        this.content.append(new String(stream));
        this.hasDocid = in.readBoolean();
        if (this.hasDocid) {
            this.docid = in.readUTF();
        }
    }

    public void write(DataOutput out) throws IOException {
        String text = this.content.toString();
        out.writeInt(text.length());
        out.writeChars(text);
        out.writeBoolean(this.hasDocid);
        if (this.hasDocid) {
            out.writeUTF(this.docid);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AnchorWeightComparator
    implements Comparator<AnchorText> {
        private AnchorWeightComparator() {
        }

        @Override
        public int compare(AnchorText a, AnchorText b) {
            if (a.getType() != b.getType()) {
                return a.getType() < b.getType() ? -1 : 1;
            }
            if (a.isWeighted() && b.isWeighted()) {
                return a.getWeight() > b.getWeight() ? -1 : 1;
            }
            if (a.hasValidText() && b.hasValidText()) {
                return a.getText().compareTo(b.getText());
            }
            return 0;
        }
    }
}

