/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cloud9.webgraph.driver;

import edu.umd.cloud9.webgraph.DriverUtil;
import edu.umd.cloud9.webgraph.data.AnchorText;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import tl.lin.data.array.ArrayListWritable;

public class GenerateTabDelimitedWebGraph
extends Configured
implements Tool {
    private static int printUsage() {
        System.out.println("usage: -webgraph [WebGraph-base-path] -output [output-path]");
        ToolRunner.printGenericCommandUsage((PrintStream)System.out);
        return -1;
    }

    public int run(String[] args) throws Exception {
        if (args.length < 4) {
            GenerateTabDelimitedWebGraph.printUsage();
            return -1;
        }
        JobConf conf = new JobConf(this.getConf(), GenerateTabDelimitedWebGraph.class);
        FileSystem fs = FileSystem.get((Configuration)conf);
        String inPath = DriverUtil.argValue(args, "-webgraph") + "/" + "webGraph";
        String outPath = DriverUtil.argValue(args, "-output");
        Path inputPath = new Path(inPath);
        Path outputPath = new Path(outPath);
        if (fs.exists(outputPath)) {
            fs.delete(outputPath);
        }
        conf.setJobName("TabDelimWebGraph");
        conf.set("mapred.child.java.opts", "-Xmx2048m");
        conf.set("mapreduce.map.memory.mb", "2048");
        conf.set("mapreduce.map.java.opts", "-Xmx2048m");
        conf.set("mapreduce.reduce.memory.mb", "2048");
        conf.set("mapreduce.reduce.java.opts", "-Xmx2048m");
        conf.set("mapreduce.task.timeout", "60000000");
        conf.setNumMapTasks(1);
        conf.setNumReduceTasks(0);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inputPath});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outputPath);
        conf.setInputFormat(SequenceFileInputFormat.class);
        conf.setOutputFormat(TextOutputFormat.class);
        conf.setOutputKeyClass(IntWritable.class);
        conf.setOutputValueClass(Text.class);
        conf.setMapperClass(MyMapper.class);
        JobClient.runJob((JobConf)conf);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new GenerateTabDelimitedWebGraph(), (String[])args);
        System.exit(res);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyMapper
    extends MapReduceBase
    implements Mapper<IntWritable, ArrayListWritable<AnchorText>, IntWritable, Text> {
        private static final Text valueOutput = new Text();
        private static final StringBuilder buffer = new StringBuilder();

        private MyMapper() {
        }

        public void map(IntWritable key, ArrayListWritable<AnchorText> anchors, OutputCollector<IntWritable, Text> output, Reporter reporter) throws IOException {
            buffer.delete(0, buffer.length());
            for (AnchorText p : anchors) {
                if (!p.isExternalOutLink() && !p.isInternalOutLink()) continue;
                for (int doc : p) {
                    buffer.append(doc + "\t");
                }
            }
            valueOutput.set(buffer.toString());
            output.collect((Object)key, (Object)valueOutput);
        }
    }
}

