/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.hooka;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.io.Writable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Alignment
implements Writable,
Iterable<IntPair>,
Cloneable {
    protected short _elen;
    protected short _flen;
    boolean[] faligned;
    boolean[] ealigned;
    M2 _aligned;
    static Pattern eline_re = Pattern.compile("([^\\s]+)\\s+\\(\\{\\s+((?:\\d+\\s+)*)\\}\\)");
    public static final int[][] DIAG_NEIGHBORS = new int[][]{{0, -1}, {-1, 0}, {1, 0}, {0, 1}, {1, 1}, {-1, -1}, {1, -1}, {-1, 1}};
    public static final int[][] NEIGHBORS = new int[][]{{0, -1}, {-1, 0}, {1, 0}, {0, 1}};
    public static final int[][][] LNEIGHBORS = new int[][][]{new int[][]{{0, 1}, {1, 1}, {1, 0}}, new int[][]{{1, 0}, {1, -1}, {0, -1}}, new int[][]{{0, -1}, {-1, -1}, {-1, 0}}, new int[][]{{-1, 0}, {-1, 1}, {0, 1}}};

    public int countAlignmentPoints() {
        int count = 0;
        for (int j = 0; j < this._flen; ++j) {
            for (int i = 0; i < this._elen; ++i) {
                if (!this.aligned(j, i)) continue;
                ++count;
            }
        }
        return count;
    }

    public Alignment mergeEnglishWords(int i, int j) {
        if (i + 1 != j) {
            throw new IllegalArgumentException("mergeEnglishWords can only combine adjacent positions! " + i + "," + j);
        }
        Alignment res = new Alignment(this._flen, this._elen - 1);
        for (int a = 0; a < this._flen; ++a) {
            for (int b = 0; b < this._elen; ++b) {
                if (!this.aligned(a, b)) continue;
                int ee = b;
                if (b > i) {
                    --ee;
                }
                res.align(a, ee);
            }
        }
        return res;
    }

    public Alignment splitEnglishWords(int i) {
        Alignment res = new Alignment(this._flen, this._elen + 1);
        for (int a = 0; a < this._flen; ++a) {
            for (int b = 0; b < this._elen; ++b) {
                if (!this.aligned(a, b)) continue;
                int ee = b;
                if (b == i) {
                    res.align(a, i);
                }
                if (b >= i) {
                    ++ee;
                }
                res.align(a, ee);
            }
        }
        return res;
    }

    public Alignment splitForeignWords(int j) {
        Alignment res = new Alignment(this._flen + 1, this._elen);
        for (int a = 0; a < this._flen; ++a) {
            for (int b = 0; b < this._elen; ++b) {
                if (!this.aligned(a, b)) continue;
                int ee = a;
                if (a == j) {
                    res.align(j, b);
                }
                if (a >= j) {
                    ++ee;
                }
                res.align(ee, b);
            }
        }
        return res;
    }

    public void readFields(DataInput in) throws IOException {
        if (this._aligned == null) {
            this._aligned = new M2();
        }
        this._aligned.readFields(in);
        this._flen = this._aligned._w;
        this._elen = (short)(this._aligned._data.length / this._flen);
        this.faligned = new boolean[this._flen];
        this.ealigned = new boolean[this._elen];
        for (int f = 0; f < this._flen; ++f) {
            for (int e = 0; e < this._elen; ++e) {
                if (!this.aligned(f, e)) continue;
                this.faligned[f] = true;
                this.ealigned[e] = true;
            }
        }
    }

    public byte getType() {
        return 1;
    }

    public Object clone() {
        Alignment res = new Alignment();
        res._aligned = (M2)this._aligned.clone();
        res._elen = this._elen;
        res._flen = this._flen;
        res.ealigned = (boolean[])this.ealigned.clone();
        res.faligned = (boolean[])this.faligned.clone();
        return res;
    }

    public void write(DataOutput out) throws IOException {
        this._aligned.write(out);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Alignment)) {
            return false;
        }
        return this._aligned.equals(((Alignment)o)._aligned);
    }

    public boolean neighborAligned(int i, int j) {
        return this.countNeighbors(i, j, DIAG_NEIGHBORS) > 0;
    }

    public boolean lneighborAligned(int i, int j) {
        for (int x = 0; x < LNEIGHBORS.length; ++x) {
            if (this.countNeighbors(i, j, LNEIGHBORS[x]) < 2) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<IntPair> iterator() {
        return new AIterator(this);
    }

    public final int countNeighbors(int f, int e, int[][] rels) {
        int res = 0;
        for (int x = 0; x < rels.length; ++x) {
            int cf = f + rels[x][0];
            int ce = e + rels[x][1];
            if (cf < 0 || cf >= this._flen || ce < 0 || ce >= this._elen || !this.aligned(cf, ce)) continue;
            ++res;
        }
        return res;
    }

    public final boolean rookAligned(int i, int j) {
        return this.faligned[i] || this.ealigned[j];
    }

    public final boolean doubleRookAligned(int i, int j) {
        return this.faligned[i] && this.ealigned[j];
    }

    public final int getELength() {
        return this._elen;
    }

    public final int getFLength() {
        return this._flen;
    }

    public Alignment() {
        this._elen = 0;
        this._flen = 0;
        this._aligned = null;
    }

    public Alignment(int flen, int elen) {
        this._elen = (short)elen;
        this._flen = (short)flen;
        this.alloc();
    }

    public Alignment(int flen, int elen, String pa) {
        String[] aps;
        this._elen = (short)elen;
        this._flen = (short)flen;
        this.alloc();
        if (pa == null || pa.length() == 0) {
            return;
        }
        for (String ap : aps = pa.split("\\s+")) {
            String[] pair = ap.split("-");
            if (pair.length != 2) {
                throw new IllegalArgumentException("Malformed alignment string: " + pa);
            }
            int f = Integer.parseInt(pair[0]);
            int e = Integer.parseInt(pair[1]);
            if (f >= this._flen || e >= this._elen) {
                throw new IndexOutOfBoundsException("out of bounds: " + f + "," + e);
            }
            this.align(f, e);
        }
    }

    private void alloc() {
        this.faligned = new boolean[this._flen];
        this.ealigned = new boolean[this._elen];
        this._aligned = new M2(this._flen, this._elen);
    }

    public final boolean aligned(int f, int e) {
        return this._aligned.get(f, e);
    }

    public final void align(int f, int e) {
        this._aligned.set(f, e);
        this.faligned[f] = true;
        this.ealigned[e] = true;
    }

    public final boolean isEAligned(int e) {
        return this.ealigned[e];
    }

    public final boolean isFAligned(int f) {
        return this.faligned[f];
    }

    public final void unalignF(int f) {
        this.faligned[f] = false;
        for (int i = 0; i < this._elen; ++i) {
            this._aligned.reset(f, i);
        }
    }

    public final void unalignE(int e) {
        this.ealigned[e] = false;
        for (int i = 0; i < this._flen; ++i) {
            this._aligned.reset(i, e);
        }
    }

    public static Alignment fromGiza(String eline, String fline, boolean transpose) {
        Matcher es = eline_re.matcher(fline);
        es.find();
        boolean skipNull = false;
        if (es.group(1).equals("NULL")) {
            skipNull = true;
        } else {
            es.reset();
        }
        ArrayList<String> afwords = new ArrayList<String>();
        while (es.find()) {
            afwords.add(es.group(1));
        }
        String[] ewords = eline.split("\\s+");
        Alignment al = null;
        al = transpose ? new Alignment(ewords.length, afwords.size()) : new Alignment(afwords.size(), ewords.length);
        es.reset();
        if (skipNull) {
            es.find();
        }
        int i = 0;
        while (es.find()) {
            String saligns = es.group(2);
            if (!saligns.matches("^\\s*$")) {
                String[] aligns = saligns.split("\\s+");
                for (int k = 0; k < aligns.length; ++k) {
                    int j = Integer.parseInt(aligns[k]) - 1;
                    if (transpose) {
                        al.align(j, i);
                        continue;
                    }
                    al.align(i, j);
                }
            }
            ++i;
        }
        return al;
    }

    public Alignment getTranspose() {
        Alignment res = new Alignment(this._elen, this._flen);
        for (int ei = 0; ei < this._elen; ++ei) {
            for (int fi = 0; fi < this._flen; ++fi) {
                if (!this.aligned(fi, ei)) continue;
                res.align(ei, fi);
            }
        }
        return res;
    }

    public String toStringVisual() {
        StringBuffer sb = new StringBuffer();
        sb.append(' ');
        for (int j = 0; j < this._flen; ++j) {
            sb.append(j % 10);
        }
        sb.append('\n');
        for (int i = 0; i < this._elen; ++i) {
            sb.append(i % 10);
            for (int j = 0; j < this._flen; ++j) {
                if (this.aligned(j, i)) {
                    sb.append('*');
                    continue;
                }
                sb.append('.');
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this._flen; ++i) {
            for (int j = 0; j < this._elen; ++j) {
                if (!this.aligned(i, j)) continue;
                sb.append(i).append('-').append(j).append(' ');
            }
        }
        if (sb.length() > 0) {
            sb.delete(sb.length() - 1, sb.length());
        }
        return sb.toString();
    }

    public static Alignment intersect(Alignment a1, Alignment a2) {
        Alignment a = new Alignment(a1._flen, a1._elen);
        for (int i = 0; i < a1._flen; ++i) {
            for (int j = 0; j < a1._elen; ++j) {
                if (!a1.aligned(i, j) || !a2.aligned(i, j)) continue;
                a.align(i, j);
            }
        }
        return a;
    }

    public static Alignment union(Alignment a1, Alignment a2) {
        Alignment a = new Alignment(a1._flen, a1._elen);
        for (int i = 0; i < a1._flen; ++i) {
            for (int j = 0; j < a1._elen; ++j) {
                if (!a1.aligned(i, j) && !a2.aligned(i, j)) continue;
                a.align(i, j);
            }
        }
        return a;
    }

    protected static final class M2
    implements Cloneable {
        public short _w;
        public boolean[] _data;

        public Object clone() {
            M2 res = new M2();
            res._data = (boolean[])this._data.clone();
            res._w = this._w;
            return res;
        }

        public M2() {
            this._w = 0;
            this._data = null;
        }

        public M2(int f, int e) {
            this._data = new boolean[f * e];
            this._w = (short)f;
        }

        void eraseFirstEWord() {
            boolean[] nd = new boolean[this._data.length - this._w];
            System.arraycopy(nd, 0, this._data, 0, this._data.length - this._w);
            this._data = nd;
        }

        boolean equals(M2 other) {
            if (other._w != this._w) {
                return false;
            }
            return Arrays.equals(this._data, other._data);
        }

        public boolean get(int f, int e) {
            return this._data[this._w * e + f];
        }

        public void set(int f, int e) {
            try {
                this._data[this._w * e + f] = true;
            }
            catch (ArrayIndexOutOfBoundsException ee) {
                throw new RuntimeException("Set(" + f + ", " + e + "): caught " + ee);
            }
        }

        public void reset(int f, int e) {
            this._data[this._w * e + f] = false;
        }

        public void readFields(DataInput in) throws IOException {
            this._w = in.readShort();
            char size = in.readChar();
            if (size < '\u0001') {
                throw new RuntimeException("Error: " + size + " is not good for alignment!");
            }
            this._data = new boolean[size];
            int bbLen = in.readInt();
            short[] faps = new short[bbLen / 2];
            short[] eaps = new short[bbLen / 2];
            ByteBuffer bb = ByteBuffer.allocate(bbLen);
            in.readFully(bb.array());
            ShortBuffer sb = bb.asShortBuffer();
            sb.get(faps);
            bb.clear();
            in.readFully(bb.array());
            sb = bb.asShortBuffer();
            sb.get(eaps);
            for (int i = 0; i < faps.length; ++i) {
                this.set(faps[i], eaps[i]);
            }
        }

        public void write(DataOutput out) throws IOException {
            out.writeShort(this._w);
            out.writeShort((short)this._data.length);
            int c = 0;
            for (int i = 0; i < this._data.length; ++i) {
                if (!this._data[i]) continue;
                ++c;
            }
            short[] faps = new short[c];
            short[] eaps = new short[c];
            c = 0;
            for (int i = 0; i < this._data.length; ++i) {
                if (!this._data[i]) continue;
                faps[c] = (short)(i % this._w);
                eaps[c] = (short)(i / this._w);
                ++c;
            }
            int bbLen = faps.length * 2;
            out.writeInt(bbLen);
            ByteBuffer bb = ByteBuffer.allocate(bbLen);
            ShortBuffer sb = bb.asShortBuffer();
            sb.put(faps);
            out.write(bb.array());
            sb.clear();
            sb.put(eaps);
            out.write(bb.array());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AIterator
    implements Iterator<IntPair> {
        int cur;
        boolean[] d;
        int w;

        protected AIterator(Alignment a) {
            this.d = a._aligned._data;
            this.w = a._aligned._w;
            this.cur = 0;
            this.advance();
        }

        protected void advance() {
            while (this.cur < this.d.length && !this.d[this.cur]) {
                ++this.cur;
            }
        }

        @Override
        public boolean hasNext() {
            return this.cur < this.d.length;
        }

        @Override
        public IntPair next() {
            IntPair res = new IntPair(this.cur % this.w, this.cur / this.w);
            ++this.cur;
            this.advance();
            return res;
        }

        @Override
        public void remove() {
        }
    }

    public class IntPair {
        public int f;
        public int e;

        public IntPair(int f, int e) {
            this.f = f;
            this.e = e;
        }

        public String toString() {
            return this.f + "-" + this.e;
        }
    }
}

