/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.hooka;

import edu.umd.hooka.Alignment;
import edu.umd.hooka.Array2D;
import edu.umd.hooka.PhrasePair;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class AlignmentPosteriorGrid {
    Array2D posteriors;
    int elen = 0;
    int flen = 0;

    public void write(DataOutput out) throws IOException {
        throw new IOException("foo");
    }

    public void readFiles(DataInput in) throws IOException {
        throw new IOException("foo");
    }

    public AlignmentPosteriorGrid(PhrasePair pp) {
        this.elen = pp.getE().getWords().length + 1;
        this.flen = pp.getF().getWords().length;
        this.posteriors = new Array2D(this.elen * this.flen);
        this.posteriors.resize(this.flen, this.elen);
    }

    public float getAlignmentPointPosterior(int f, int e) {
        return this.posteriors.get(f, e);
    }

    public void setAlignmentPointPosterior(int f, int e, float p) {
        this.posteriors.set(f, e, p);
    }

    public Alignment alignPosteriorThreshold(float t) {
        Alignment res = new Alignment(this.flen, this.elen - 1);
        for (int i = 1; i < this.elen; ++i) {
            for (int j = 0; j < this.flen; ++j) {
                if (!(this.getAlignmentPointPosterior(j, i) > t)) continue;
                res.align(j, i - 1);
            }
        }
        return res;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.posteriors.getSize2(); ++i) {
            for (int j = 0; j < this.posteriors.getSize1(); ++j) {
                float p = this.posteriors.get(j, i);
                if (p > 0.0f) {
                    double lp = Math.log(p);
                    int c = 10000;
                    if (lp <= -10.0) {
                        c /= 10;
                    }
                    if (lp <= -100.0) {
                        c /= 10;
                    }
                    if (lp <= -1000.0) {
                        c /= 10;
                    }
                    if (lp <= -10000.0) {
                        c /= 10;
                    }
                    int ip = (int)(lp * (double)c);
                    float llp = (float)ip / (float)c;
                    sb.append(llp);
                } else {
                    sb.append("-inf");
                }
                sb.append('\t');
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

