/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.hooka;

import edu.umd.hooka.ArabicRawTruncator;
import edu.umd.hooka.GermanTruncator;
import edu.umd.hooka.HungarianTruncator;
import edu.umd.hooka.NullPreprocessor;
import edu.umd.hooka.Truncator;
import edu.umd.hooka.corpora.Language;
import edu.umd.hooka.corpora.LanguagePair;
import org.apache.hadoop.conf.Configuration;

public abstract class AlignmentWordPreprocessor {
    public final String[] preprocessWordsForAlignment(String[] arg) {
        String[] res = this.preprocessWordsImpl(arg);
        assert (res.length == arg.length);
        return res;
    }

    protected abstract String[] preprocessWordsImpl(String[] var1);

    public static AlignmentWordPreprocessor CreatePreprocessor(LanguagePair lp, Language l, Configuration conf) {
        if (l == null) {
            return new NullPreprocessor(conf);
        }
        if (l == Language.languageForISO639_1("en")) {
            return new Truncator(conf);
        }
        if (l == Language.languageForISO639_1("de")) {
            return new GermanTruncator(conf);
        }
        if (l == Language.languageForISO639_1("ar")) {
            return new ArabicRawTruncator(conf);
        }
        if (l == Language.languageForISO639_1("hu")) {
            return new HungarianTruncator(conf);
        }
        return new Truncator(conf);
    }
}

