/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.hooka;

import edu.umd.hooka.alignment.ZeroProbabilityException;
import java.util.Arrays;

public final class Array2D {
    float[] data;
    int width;
    int size;

    public Array2D(int maxCap) {
        this.data = new float[maxCap];
    }

    public void resize(int x, int y) {
        int s = x * y;
        if (s > this.data.length) {
            throw new RuntimeException("Requested size larger than allocated space: x=" + x + " y=" + y);
        }
        this.size = s;
        this.width = x;
        this.fill(0.0f);
    }

    public void fill(float val) {
        Arrays.fill(this.data, 0, this.size, val);
    }

    public float get(int x, int y) {
        return this.data[y * this.width + x];
    }

    public void set(int x, int y, float v) {
        this.data[y * this.width + x] = v;
    }

    public int getSize1() {
        return this.width;
    }

    public int getSize2() {
        return this.size / this.width;
    }

    public float normalizeColumn(int c) {
        int i;
        float sum = 0.0f;
        int cur = c;
        int r = this.getSize2();
        for (i = 0; i < r; ++i) {
            sum += this.data[cur];
            cur += this.width;
        }
        if (sum == 0.0f) {
            StringBuffer sb = new StringBuffer();
            sb.append("normalizeColumn(").append(c).append("):");
            cur = c;
            for (int i2 = 0; i2 < r; ++i2) {
                sb.append(' ').append(this.data[cur]);
                cur += this.width;
            }
            sb.append(" sum=0.0");
            throw new ZeroProbabilityException(sb.toString());
        }
        cur = c;
        for (i = 0; i < r; ++i) {
            int n = cur;
            this.data[n] = this.data[n] / sum;
            cur += this.width;
        }
        return sum;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int r = this.getSize2();
        int c = this.getSize1();
        for (int j = 0; j < r; ++j) {
            for (int i = 0; i < c; ++i) {
                sb.append("  ").append(this.get(i, j));
            }
            sb.append('\n');
        }
        return sb.toString();
    }
}

