/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.hooka;

import edu.umd.hooka.AlignmentWordPreprocessor;
import edu.umd.hooka.corpora.Chunk;
import edu.umd.hooka.corpora.Language;
import edu.umd.hooka.corpora.LanguagePair;
import edu.umd.hooka.corpora.ParallelChunk;
import edu.umd.hooka.corpora.ParallelCorpusReader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class CreateWordAlignmentCorpus {
    public static void main(String[] args) {
        if (args.length != 3) {
            System.err.println("Usage: CreateWordAlignmentCorpus <lang> <infile.txt> <outfile.txt>");
            System.err.println("          (note: lang must be a two-letter ISO639 code)");
            System.exit(1);
        }
        try {
            String l;
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(args[1]), "UTF8"));
            Language fl = Language.languageForISO639_1(args[0]);
            LanguagePair lp = LanguagePair.languageForISO639_1Pair(args[0] + "-en");
            AlignmentWordPreprocessor sawp = AlignmentWordPreprocessor.CreatePreprocessor(lp, fl, null);
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(args[2]), "UTF8"));
            while ((l = in.readLine()) != null) {
                String[] res = sawp.preprocessWordsForAlignment(l.split("\\s+"));
                boolean first = true;
                for (String r : res) {
                    if (first) {
                        first = false;
                    } else {
                        out.write(32);
                    }
                    out.write(r);
                }
                out.newLine();
            }
            out.flush();
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    static class WriterCallback
    implements ParallelCorpusReader.PChunkCallback {
        BufferedWriter ew;
        BufferedWriter fw;
        BufferedWriter lw;
        Language ar = Language.languageForISO639_1("ar");
        Language en = Language.languageForISO639_1("en");
        LanguagePair lp = LanguagePair.languageForISO639_1Pair("ar-en");
        AlignmentWordPreprocessor sawp;
        AlignmentWordPreprocessor tawp;
        static final int MAX_LENGTH = 99;

        WriterCallback(String e, String f, String l) throws IOException {
            this.ew = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(e), "UTF8"));
            this.fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF8"));
            this.lw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(l), "UTF8"));
            this.sawp = AlignmentWordPreprocessor.CreatePreprocessor(this.lp, this.ar, null);
            this.tawp = AlignmentWordPreprocessor.CreatePreprocessor(this.lp, this.en, null);
        }

        public void close() throws IOException {
            this.ew.flush();
            this.ew.close();
            this.fw.flush();
            this.fw.close();
        }

        public void handlePChunk(ParallelChunk p) {
            Chunk a = p.getChunk(this.ar);
            Chunk e = p.getChunk(this.en);
            if (a == null) {
                return;
            }
            if (e == null) {
                return;
            }
            String[] npa = a.getWords();
            String[] npe = e.getWords();
            if (npa.length > 99) {
                return;
            }
            if (npe.length > 99) {
                return;
            }
            if (npa.length == 0 || npe.length == 0) {
                return;
            }
            String[] aws = this.sawp.preprocessWordsForAlignment(npa);
            String[] ews = this.tawp.preprocessWordsForAlignment(npe);
            StringBuffer asb = new StringBuffer();
            for (String i : aws) {
                asb.append(i).append(' ');
            }
            asb.deleteCharAt(asb.length() - 1);
            StringBuffer esb = new StringBuffer();
            for (String i : ews) {
                esb.append(i).append(' ');
            }
            esb.deleteCharAt(esb.length() - 1);
            try {
                this.lw.write(p.getName());
                this.fw.write(asb.toString());
                this.ew.write(esb.toString());
                this.lw.newLine();
                this.fw.newLine();
                this.ew.newLine();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                System.exit(1);
            }
        }
    }
}

