/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.hooka;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileListing {
    public static void main(String ... aArgs) throws FileNotFoundException {
        File tempDir = new File(aArgs[0]);
        List<File> files = FileListing.getFileListing(tempDir);
        for (File file : files) {
            System.out.println(file);
        }
    }

    public static List<File> getFileListing(File aStartingDir) throws FileNotFoundException {
        FileListing.validateDirectory(aStartingDir);
        ArrayList<File> result = new ArrayList<File>();
        File[] filesAndDirs = aStartingDir.listFiles();
        List<File> filesDirs = Arrays.asList(filesAndDirs);
        for (File file : filesDirs) {
            if (file.isFile()) {
                result.add(file);
                continue;
            }
            List<File> deeperList = FileListing.getFileListing(file);
            result.addAll(deeperList);
        }
        Collections.sort(result);
        return result;
    }

    private static void validateDirectory(File aDirectory) throws FileNotFoundException {
        if (aDirectory == null) {
            throw new IllegalArgumentException("Directory should not be null.");
        }
        if (!aDirectory.exists()) {
            throw new FileNotFoundException("Directory does not exist: " + aDirectory);
        }
        if (!aDirectory.isDirectory()) {
            throw new IllegalArgumentException("Is not a directory: " + aDirectory);
        }
        if (!aDirectory.canRead()) {
            throw new IllegalArgumentException("Directory cannot be read: " + aDirectory);
        }
    }
}

