/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.hooka;

import edu.umd.hooka.alignment.IndexedFloatArray;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.hadoop.io.FloatWritable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Int2FloatMap {
    TreeMap<Integer, FloatWritable> data = new TreeMap();

    public final void increment(int k, float delta) {
        FloatWritable cvF = this.data.get(k);
        cvF.set(cvF.get() + delta);
    }

    public final Set<Map.Entry<Integer, FloatWritable>> entrySet() {
        return this.data.entrySet();
    }

    public final int maxKey() {
        return this.data.lastKey();
    }

    public final void createIfMissing(int k) {
        Integer ki = new Integer(k);
        if (this.data.get(ki) == null) {
            FloatWritable n = new FloatWritable();
            this.data.put(k, n);
        }
    }

    public final void set(int k, float value) {
        this.data.get(k).set(value);
    }

    public final float get(int k) {
        return this.data.get(k).get();
    }

    public final FloatWritable getFloatWritable(int k) {
        return this.data.get(k);
    }

    public IndexedFloatArray getAsIndexedFloatArray() {
        int[] indices = new int[this.data.size()];
        float[] values = new float[this.data.size()];
        int c = 0;
        for (Map.Entry<Integer, FloatWritable> p : this.data.entrySet()) {
            indices[c] = p.getKey();
            values[c] = p.getValue().get();
            ++c;
        }
        return new IndexedFloatArray(indices, values);
    }
}

