/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.hooka;

import edu.umd.hooka.Vocab;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.TreeSet;
import org.apache.hadoop.io.WritableComparable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Phrase
implements WritableComparable,
Cloneable {
    byte _language;
    int[] _words;

    public Object clone() {
        Phrase res = new Phrase();
        res._language = this._language;
        if (this._words != null) {
            res._words = (int[])this._words.clone();
        }
        return res;
    }

    public Phrase() {
    }

    public Phrase(int[] p, int lang) {
        this._language = (byte)lang;
        this._words = p;
    }

    public int size() {
        if (this._words == null) {
            return 0;
        }
        return this._words.length;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Phrase)) {
            return false;
        }
        Phrase that = (Phrase)o;
        if (this._language != that._language) {
            return false;
        }
        if (that._words.length != this._words.length) {
            return false;
        }
        return Arrays.equals(this._words, that._words);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[L=").append(this._language);
        if (this._words != null) {
            for (int i = 0; i < this._words.length; ++i) {
                sb.append(' ').append(this._words[i]);
            }
        }
        sb.append(']');
        return sb.toString();
    }

    public int compareTo(Object o) {
        Phrase that = (Phrase)o;
        if (this._language != that._language) {
            return that._language - this._language;
        }
        if (this._words == null || that._words == null) {
            int a = 0;
            if (this._words != null) {
                a = this._words.length;
            }
            int b = 0;
            if (that._words != null) {
                b = that._words.length;
            }
            return b - a;
        }
        for (int i = 0; i < this._words.length && i < that._words.length; ++i) {
            int a = this._words[i];
            int b = that._words[i];
            if (a == b) continue;
            return a - b;
        }
        return this._words.length - that._words.length;
    }

    public int hashCode() {
        int hc = this._language + 73;
        if (this._words != null) {
            for (int i = 0; i < this._words.length; ++i) {
                hc = 31 * hc + this._words[i];
            }
        }
        return hc;
    }

    public String toString(Vocab voc) {
        StringBuffer sb = new StringBuffer();
        if (this._words != null) {
            for (int i = 0; i < this._words.length; ++i) {
                if (i != 0) {
                    sb.append(' ');
                }
                sb.append(voc.get(this._words[i]));
            }
        }
        return sb.toString();
    }

    public int[] getWords() {
        return this._words;
    }

    public TreeSet<Integer> getWordsWithoutDuplicates() {
        TreeSet<Integer> vals = new TreeSet<Integer>();
        for (int i = 0; i < this._words.length; ++i) {
            vals.add(new Integer(this._words[i]));
        }
        return vals;
    }

    public byte getLanguage() {
        return this._language;
    }

    public void setLanguage(int l) {
        this._language = (byte)l;
    }

    public Phrase getSubPhrase(int start, int end) {
        Phrase res = new Phrase();
        res._language = this._language;
        res._words = new int[end - start + 1];
        System.arraycopy(this._words, start, res._words, 0, end - start + 1);
        return res;
    }

    public static Phrase fromString(int lang, String sentence, Vocab voc) {
        Phrase s = new Phrase();
        s._language = (byte)lang;
        String[] w = sentence.split("\\s+");
        s._words = new int[w.length];
        for (int i = 0; i < w.length; ++i) {
            s._words[i] = voc.addOrGet(w[i]);
        }
        return s;
    }

    public void readFields(DataInput in) throws IOException {
        this._language = in.readByte();
        int bbLen = in.readInt();
        if (bbLen == 0) {
            this._words = null;
            return;
        }
        ByteBuffer bb = ByteBuffer.allocate(bbLen);
        in.readFully(bb.array());
        IntBuffer ib = bb.asIntBuffer();
        this._words = new int[bbLen / 4];
        ib.get(this._words);
    }

    public void setWords(int[] words) {
        this._words = words;
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(this._language);
        int bbLen = 0;
        if (this._words != null) {
            bbLen = this._words.length * 4;
        }
        out.writeInt(bbLen);
        if (bbLen == 0) {
            return;
        }
        ByteBuffer bb = ByteBuffer.allocate(bbLen);
        IntBuffer ib = bb.asIntBuffer();
        ib.put(this._words);
        out.write(bb.array());
    }
}

