/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.hooka;

import edu.umd.hooka.CorpusInfo;
import edu.umd.hooka.Phrase;
import edu.umd.hooka.PhrasePair;
import edu.umd.hooka.alignment.IndexedFloatArray;
import java.io.IOException;
import java.rmi.UnexpectedException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;

public class PhraseExtractAndCount {
    public static void main(String[] args) throws IOException {
        CorpusInfo corpus = CorpusInfo.getCorpus(CorpusInfo.Corpus.ARABIC_500k);
        Path ppCountTemp = new Path("ppc.paircount.tmp");
        Path ppMarginalTemp = new Path("ppc.marginals.tmp");
        Path ppPtableTemp = new Path("ppc.ptable.tmp");
        int mapTasks = 38;
        int reduceTasks = 38;
        JobConf conf = new JobConf(PhraseExtractAndCount.class);
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.delete(ppCountTemp);
        fs.delete(ppMarginalTemp);
        fs.delete(ppPtableTemp);
        fs.delete(corpus.getLocalPhraseTable());
        conf.setJobName("PhraseExtractAndCount");
        conf.setOutputKeyClass(PhrasePair.class);
        conf.setOutputValueClass(IntWritable.class);
        conf.setMapperClass(MapClass1.class);
        conf.setCombinerClass(Reduce.class);
        conf.setReducerClass(Reduce.class);
        conf.setNumMapTasks(mapTasks);
        conf.setNumReduceTasks(reduceTasks);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{corpus.getAlignedBitext()});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)ppCountTemp);
        conf.setInputFormat(SequenceFileInputFormat.class);
        conf.setOutputFormat(SequenceFileOutputFormat.class);
        JobClient.runJob((JobConf)conf);
        conf = new JobConf(PhraseExtractAndCount.class);
        conf.setJobName("PhraseExtractAndCount_marginals");
        conf.setInputFormat(SequenceFileInputFormat.class);
        conf.setOutputKeyClass(PhrasePair.class);
        conf.setOutputValueClass(IntWritable.class);
        conf.setMapperClass(MapClass2.class);
        conf.setCombinerClass(Reduce.class);
        conf.setReducerClass(Reduce.class);
        conf.setNumMapTasks(mapTasks);
        conf.setNumReduceTasks(reduceTasks);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{ppCountTemp});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)ppMarginalTemp);
        conf.setOutputFormat(SequenceFileOutputFormat.class);
        JobClient.runJob((JobConf)conf);
        conf = new JobConf(PhraseExtractAndCount.class);
        conf.setJobName("PhraseExtractAndCount_ptscore");
        conf.setInputFormat(SequenceFileInputFormat.class);
        conf.setOutputFormat(SequenceFileOutputFormat.class);
        conf.setOutputKeyClass(PhrasePair.class);
        conf.setMapOutputValueClass(IntWritable.class);
        conf.setOutputValueClass(FloatWritable.class);
        conf.setMapperClass(MapClass3.class);
        conf.setReducerClass(ReducePT.class);
        conf.setNumMapTasks(mapTasks);
        conf.setNumReduceTasks(reduceTasks);
        FileInputFormat.addInputPath((JobConf)conf, (Path)ppCountTemp);
        FileInputFormat.addInputPath((JobConf)conf, (Path)ppMarginalTemp);
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)ppPtableTemp);
        JobClient.runJob((JobConf)conf);
        conf = new JobConf(PhraseExtractAndCount.class);
        conf.setJobName("PhraseExtractAndCount_ptcombine");
        conf.setInputFormat(SequenceFileInputFormat.class);
        conf.setOutputKeyClass(PhrasePair.class);
        conf.setOutputValueClass(IndexedFloatArray.class);
        conf.setMapperClass(MapClass4.class);
        conf.setReducerClass(ReduceSumScores.class);
        conf.setNumMapTasks(mapTasks);
        conf.setNumReduceTasks(reduceTasks);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{ppPtableTemp});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)corpus.getLocalPhraseTable());
        JobClient.runJob((JobConf)conf);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ReduceSumScores
    extends MapReduceBase
    implements Reducer<PhrasePair, IndexedFloatArray, PhrasePair, IndexedFloatArray> {
        IndexedFloatArray scores = new IndexedFloatArray(2);

        public void reduce(PhrasePair key, Iterator<IndexedFloatArray> values, OutputCollector<PhrasePair, IndexedFloatArray> output, Reporter reporter) throws IOException {
            this.scores.clear();
            while (values.hasNext()) {
                this.scores.plusEquals(values.next());
            }
            output.collect((Object)key, (Object)this.scores);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ReducePT
    extends MapReduceBase
    implements Reducer<PhrasePair, IntWritable, PhrasePair, FloatWritable> {
        float marginal = 0.0f;
        int need_to_cover = 0;
        FloatWritable prob = new FloatWritable(0.0f);

        public void reduce(PhrasePair key, Iterator<IntWritable> values, OutputCollector<PhrasePair, FloatWritable> output, Reporter reporter) throws IOException {
            if (!values.hasNext()) {
                throw new UnexpectedException("no values for " + key);
            }
            int v = values.next().get();
            if (this.need_to_cover == 0) {
                if (key.getE().size() != 0) {
                    throw new UnexpectedException("Expected empty e-side: " + key);
                }
                this.need_to_cover = v;
                if (v < 1) {
                    throw new UnexpectedException("Bad count: " + v);
                }
                this.marginal = v;
            } else {
                if (key.getE().size() == 0) {
                    throw new UnexpectedException("unaccounted for counts: " + this.need_to_cover + " key=" + key);
                }
                float p = (float)v / this.marginal;
                this.prob.set(p);
                output.collect((Object)key, (Object)this.prob);
                this.need_to_cover -= v;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Reduce
    extends MapReduceBase
    implements Reducer<PhrasePair, IntWritable, PhrasePair, IntWritable> {
        IntWritable res = new IntWritable();

        public void reduce(PhrasePair key, Iterator<IntWritable> values, OutputCollector<PhrasePair, IntWritable> output, Reporter reporter) throws IOException {
            int sum = 0;
            while (values.hasNext()) {
                sum += values.next().get();
            }
            this.res.set(sum);
            output.collect((Object)key, (Object)this.res);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapClass4
    extends MapReduceBase
    implements Mapper<PhrasePair, FloatWritable, PhrasePair, IndexedFloatArray> {
        IndexedFloatArray scores = new IndexedFloatArray(2);

        public void map(PhrasePair key, FloatWritable value, OutputCollector<PhrasePair, IndexedFloatArray> output, Reporter reporter) throws IOException {
            float v = value.get();
            if (key.getF().getLanguage() == 0) {
                PhrasePair swapped = key.getTranspose();
                this.scores.set(0, 0.0f);
                this.scores.set(1, v);
                output.collect((Object)swapped, (Object)this.scores);
            } else {
                this.scores.set(0, v);
                this.scores.set(1, 0.0f);
                output.collect((Object)key, (Object)this.scores);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapClass3
    extends MapReduceBase
    implements Mapper<PhrasePair, IntWritable, PhrasePair, IntWritable> {
        public void map(PhrasePair key, IntWritable value, OutputCollector<PhrasePair, IntWritable> output, Reporter reporter) throws IOException {
            if (key.getE().size() == 0) {
                output.collect((Object)key, (Object)value);
            } else {
                output.collect((Object)key, (Object)value);
                PhrasePair swapped = key.getTranspose();
                output.collect((Object)swapped, (Object)value);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapClass2
    extends MapReduceBase
    implements Mapper<PhrasePair, IntWritable, PhrasePair, IntWritable> {
        private static final Phrase empty = new Phrase();

        MapClass2() {
            empty.setLanguage(0);
        }

        public void map(PhrasePair key, IntWritable value, OutputCollector<PhrasePair, IntWritable> output, Reporter reporter) throws IOException {
            PhrasePair k = new PhrasePair(key.getF(), key.getE());
            Phrase e = k.getE();
            k.setAlignment(null);
            k.setE(empty);
            output.collect((Object)k, (Object)value);
            k.setF(e);
            output.collect((Object)k, (Object)value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapClass1
    extends MapReduceBase
    implements Mapper<IntWritable, PhrasePair, PhrasePair, IntWritable> {
        private static final IntWritable one = new IntWritable(1);

        public void map(IntWritable key, PhrasePair value, OutputCollector<PhrasePair, IntWritable> output, Reporter reporter) throws IOException {
            ArrayList<PhrasePair> extracts = value.extractConsistentPhrasePairs(7);
            for (PhrasePair p : extracts) {
                output.collect((Object)p, (Object)one);
            }
        }
    }
}

