/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.hooka;

import edu.umd.hooka.CorpusInfo;
import edu.umd.hooka.Phrase;
import edu.umd.hooka.Phrase2CountMap;
import edu.umd.hooka.PhrasePair;
import edu.umd.hooka.alignment.IndexedFloatArray;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;

public class PhraseExtractAndCount_stripe {
    public static void main(String[] args) throws IOException {
        CorpusInfo corpus = CorpusInfo.getCorpus(CorpusInfo.Corpus.ARABIC_5000k);
        Path ppCountTemp = new Path("ppc.phase1.tmp");
        int mapTasks = 38;
        int reduceTasks = 38;
        JobConf conf = new JobConf(PhraseExtractAndCount_stripe.class);
        conf.setJobName("BuildPT.ExtractAndCount_striped");
        FileSystem.get((Configuration)conf).delete(ppCountTemp);
        FileSystem.get((Configuration)conf).delete(corpus.getLocalPhraseTable());
        conf.setOutputKeyClass(PhrasePair.class);
        conf.setOutputValueClass(IndexedFloatArray.class);
        conf.setMapOutputKeyClass(Phrase.class);
        conf.setMapOutputValueClass(Phrase2CountMap.class);
        conf.setMapperClass(PhrasePairExtractMapper.class);
        conf.setCombinerClass(PPCountCombiner.class);
        conf.setReducerClass(PPNormalizingReducer.class);
        conf.setNumMapTasks(mapTasks);
        conf.setNumReduceTasks(reduceTasks);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{corpus.getAlignedBitext()});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)ppCountTemp);
        conf.setInputFormat(SequenceFileInputFormat.class);
        conf.setOutputFormat(SequenceFileOutputFormat.class);
        JobClient.runJob((JobConf)conf);
        conf = new JobConf(PhraseExtractAndCount_stripe.class);
        conf.setJobName("BuildPT.Merge");
        conf.setInputFormat(SequenceFileInputFormat.class);
        conf.setOutputKeyClass(PhrasePair.class);
        conf.setOutputValueClass(IndexedFloatArray.class);
        conf.setReducerClass(ReduceSumScores.class);
        conf.setNumMapTasks(mapTasks);
        conf.setNumReduceTasks(reduceTasks);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{ppCountTemp});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)corpus.getLocalPhraseTable());
        JobClient.runJob((JobConf)conf);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ReduceSumScores
    extends MapReduceBase
    implements Reducer<PhrasePair, IndexedFloatArray, PhrasePair, IndexedFloatArray> {
        IndexedFloatArray scores = new IndexedFloatArray(2);

        public void reduce(PhrasePair key, Iterator<IndexedFloatArray> values, OutputCollector<PhrasePair, IndexedFloatArray> output, Reporter reporter) throws IOException {
            this.scores.clear();
            while (values.hasNext()) {
                this.scores.plusEquals(values.next());
            }
            output.collect((Object)key, (Object)this.scores);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PPNormalizingReducer
    extends MapReduceBase
    implements Reducer<Phrase, Phrase2CountMap, PhrasePair, IndexedFloatArray> {
        Phrase2CountMap sum = new Phrase2CountMap();
        PhrasePair ko = new PhrasePair();
        IndexedFloatArray scores = new IndexedFloatArray(2);

        public void reduce(Phrase key, Iterator<Phrase2CountMap> values, OutputCollector<PhrasePair, IndexedFloatArray> output, Reporter reporter) throws IOException {
            boolean transpose;
            this.sum.clear();
            int sc = 0;
            while (values.hasNext()) {
                if (++sc % 1000 == 0) {
                    reporter.progress();
                }
                this.sum.plusEquals(values.next());
            }
            this.sum.normalize();
            boolean bl = transpose = key.getLanguage() == 0;
            if (transpose) {
                this.ko.setE(key);
            } else {
                this.ko.setF(key);
            }
            for (Map.Entry i : this.sum.entrySet()) {
                this.scores.clear();
                if (transpose) {
                    this.ko.setF((Phrase)i.getKey());
                    this.scores.set(1, ((FloatWritable)i.getValue()).get());
                } else {
                    this.ko.setE((Phrase)i.getKey());
                    this.scores.set(0, ((FloatWritable)i.getValue()).get());
                }
                output.collect((Object)this.ko, (Object)this.scores);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PPCountCombiner
    extends MapReduceBase
    implements Reducer<Phrase, Phrase2CountMap, Phrase, Phrase2CountMap> {
        Phrase2CountMap sum = new Phrase2CountMap();

        public void reduce(Phrase key, Iterator<Phrase2CountMap> values, OutputCollector<Phrase, Phrase2CountMap> output, Reporter reporter) throws IOException {
            this.sum.clear();
            while (values.hasNext()) {
                this.sum.plusEquals(values.next());
            }
            output.collect((Object)key, (Object)this.sum);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PhrasePairExtractMapper
    extends MapReduceBase
    implements Mapper<IntWritable, PhrasePair, Phrase, Phrase2CountMap> {
        private final Phrase2CountMap pcm = new Phrase2CountMap();
        private static final FloatWritable one = new FloatWritable(1.0f);

        public void map(IntWritable key, PhrasePair value, OutputCollector<Phrase, Phrase2CountMap> output, Reporter reporter) throws IOException {
            ArrayList<PhrasePair> extracts = value.extractConsistentPhrasePairs(7);
            for (PhrasePair p : extracts) {
                this.pcm.clear();
                this.pcm.put(p.getF(), one);
                output.collect((Object)p.getE(), (Object)this.pcm);
                this.pcm.clear();
                this.pcm.put(p.getE(), one);
                output.collect((Object)p.getF(), (Object)this.pcm);
            }
        }
    }
}

