/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.hooka;

import edu.umd.hooka.Alignment;
import edu.umd.hooka.AlignmentPosteriorGrid;
import edu.umd.hooka.Phrase;
import edu.umd.hooka.Vocab;
import edu.umd.hooka.alignment.aer.ReferenceAlignment;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.io.WritableComparable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhrasePair
implements WritableComparable,
Cloneable {
    private Phrase f;
    private Phrase e;
    private Alignment a;
    private AlignmentPosteriorGrid g;

    public Object clone() {
        Phrase nf = (Phrase)this.f.clone();
        Phrase ne = (Phrase)this.e.clone();
        Alignment na = (Alignment)this.a.clone();
        return new PhrasePair(nf, ne, na);
    }

    public int compareTo(Object o) {
        PhrasePair that = (PhrasePair)o;
        int c = that.f.compareTo(this.f);
        if (c != 0) {
            return c;
        }
        c = that.e.compareTo(this.e);
        return c;
    }

    public int hashCode() {
        return this.f.hashCode() * 31 + this.f.size();
    }

    public PhrasePair getTranspose() {
        PhrasePair res = new PhrasePair(this.e, this.f, this.a);
        return res;
    }

    public PhrasePair() {
        this.e = new Phrase();
        this.f = new Phrase();
        this.a = null;
    }

    public PhrasePair(Phrase f, Phrase e) {
        this.f = f;
        this.e = e;
        this.a = null;
    }

    public PhrasePair(Phrase f, Phrase e, Alignment a) {
        this.f = f;
        this.e = e;
        this.a = a;
    }

    public Alignment getAlignment() {
        return this.a;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PhrasePair)) {
            return false;
        }
        PhrasePair that = (PhrasePair)o;
        if (this.a != null ? that == null || !that.a.equals(this.a) : that.a != null) {
            return false;
        }
        return this.e.equals(that.e) && this.f.equals(that.f);
    }

    public PhrasePair(String f, Vocab vocF, String e, Vocab vocE, String a) {
        this.f = Phrase.fromString(1, f, vocF);
        this.e = Phrase.fromString(0, e, vocE);
        if (a != null || !a.equals("")) {
            this.a = new Alignment(this.f.size(), this.e.size(), a);
        }
    }

    public float ratioFtoE() {
        return (float)this.f.size() / (float)this.e.size();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{F:").append(this.f).append(" ||| E:").append(this.e);
        if (this.a != null) {
            sb.append(" ||| A: ").append(this.a);
        }
        sb.append("}");
        return sb.toString();
    }

    public void mergeEnglishWords(int i, int j, int newE) {
        int elen = this.e.size();
        if (j >= elen) {
            throw new IllegalArgumentException("mergeEnglishWords argument out of range j=" + j);
        }
        if (i >= elen) {
            throw new IllegalArgumentException("mergeEnglishWords argument out of range i=" + i);
        }
        if (i == j) {
            throw new IllegalArgumentException("i cannot equal j");
        }
        int[] nep = new int[elen - 1];
        int[] ep = this.e.getWords();
        int d = 0;
        for (int k = 0; k < elen - 1; ++k) {
            if (k + d == i) {
                nep[k] = newE;
                continue;
            }
            if (k == j) {
                ++d;
            }
            nep[k] = ep[k + d];
        }
        this.e = new Phrase(nep, this.e.getLanguage());
        if (this.a != null) {
            this.a = this.a.mergeEnglishWords(i, j);
        }
    }

    public void splitEnglishWords(int i, int newE1, int newE2) {
        int elen = this.e.size();
        if (i >= elen) {
            throw new IllegalArgumentException("splitEnglishWords argument out of range: " + i);
        }
        int[] nep = new int[elen + 1];
        int[] ep = this.e.getWords();
        for (int k = 0; k < elen; ++k) {
            if (k == i) {
                nep[k] = newE1;
                nep[k + 1] = newE2;
                continue;
            }
            if (k < i) {
                nep[k] = ep[k];
                continue;
            }
            if (k <= i) continue;
            nep[k + 1] = ep[k];
        }
        this.e = new Phrase(nep, this.e.getLanguage());
        if (this.a != null) {
            this.a = this.a.splitEnglishWords(i);
        }
    }

    public void splitForeignWords(int j, int newF1, int newF2) {
        int flen = this.f.size();
        if (j >= flen) {
            throw new IllegalArgumentException("splitForeignWords argument out of range: " + j);
        }
        int[] nfp = new int[flen + 1];
        int[] fp = this.f.getWords();
        for (int k = 0; k < flen; ++k) {
            if (k == j) {
                nfp[k] = newF1;
                nfp[k + 1] = newF2;
                continue;
            }
            if (k < j) {
                nfp[k] = fp[k];
                continue;
            }
            if (k <= j) continue;
            nfp[k + 1] = fp[k];
        }
        this.f = new Phrase(nfp, this.f.getLanguage());
        if (this.a != null) {
            this.a = this.a.splitForeignWords(j);
        }
    }

    public String toString(Vocab vocF, Vocab vocE) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.f.toString(vocF)).append(" ||| ").append(this.e.toString(vocE));
        if (this.hasAlignment()) {
            sb.append(" ||| ").append(this.a.toString());
        }
        return sb.toString();
    }

    public Phrase getE() {
        return this.e;
    }

    public Phrase getF() {
        return this.f;
    }

    public void setE(Phrase e) {
        this.e = e;
    }

    public void setF(Phrase f) {
        this.f = f;
    }

    public boolean hasAlignment() {
        return this.a != null;
    }

    public void setAlignment(Alignment a) {
        if (a == null) {
            this.a = null;
            return;
        }
        if (a.getELength() != this.e.size() || a.getFLength() != this.f.size()) {
            throw new IllegalArgumentException("Mismatch p.e=" + this.e.size() + "a.e=" + a.getELength() + "  p.f=" + this.f.size() + " a.f=" + a.getFLength());
        }
        this.a = a;
    }

    public void readFields(DataInput in) throws IOException {
        boolean hasg;
        this.f.readFields(in);
        this.e.readFields(in);
        byte at = in.readByte();
        this.a = null;
        if (at != 0) {
            if (at == 1) {
                this.a = new Alignment(this.f.size(), this.e.size());
            } else if (at == 2) {
                this.a = new ReferenceAlignment(this.f.size(), this.e.size());
            } else {
                throw new IOException("bad format! at=" + at);
            }
            this.a.readFields(in);
            assert (this.a.getELength() == this.e.getWords().length);
            assert (this.a.getFLength() == this.f.getWords().length);
        }
        if (hasg = in.readBoolean()) {
            this.g = new AlignmentPosteriorGrid(this);
            this.g.readFiles(in);
        }
    }

    public void write(DataOutput out) throws IOException {
        this.f.write(out);
        this.e.write(out);
        if (this.hasAlignment()) {
            out.writeByte(this.a.getType());
            this.a.write(out);
        } else {
            out.writeByte(0);
        }
        if (this.hasAlignmentPosteriors()) {
            out.writeBoolean(true);
            this.g.write(out);
        } else {
            out.writeBoolean(false);
        }
    }

    public boolean hasAlignmentPosteriors() {
        return this.g != null;
    }

    public AlignmentPosteriorGrid getAlignmentPosteriorGrid() {
        return this.g;
    }

    public void setAlignmentPosteriorGrid(AlignmentPosteriorGrid g) {
        this.g = g;
    }

    public PhrasePair extractSubPhrasePair(SubPhraseCoordinates c) {
        return this.extractSubPhrasePair(c.f_start, c.f_end, c.e_start, c.e_end);
    }

    public PhrasePair extractSubPhrasePair(int startF, int endF, int startE, int endE) {
        PhrasePair n = new PhrasePair();
        n.e = this.e.getSubPhrase(startE, endE);
        n.f = this.f.getSubPhrase(startF, endF);
        n.a = new Alignment(endF - startF + 1, endE - startE + 1);
        for (int fi = startF; fi <= endF; ++fi) {
            for (int ei = startE; ei <= endE; ++ei) {
                if (!this.a.aligned(fi, ei)) continue;
                n.a.align(fi - startF, ei - startE);
            }
        }
        return n;
    }

    public SubPhraseCoordinates getMinimalConsistentSubPhraseCoordsContainingESpan(int e_start, int e_end) {
        int ne_s;
        int elen = this.e.size();
        int flen = this.f.size();
        int ne_e = e_end;
        for (ne_s = e_start; ne_s > 0 && !this.a.isEAligned(ne_s); --ne_s) {
        }
        while (ne_e < elen && !this.a.isEAligned(ne_e)) {
            ++ne_e;
        }
        if (ne_s < 0) {
            ne_s = 0;
        }
        if (ne_e >= elen) {
            ne_e = elen - 1;
        }
        boolean isConsistent = false;
        int maxF = -1;
        int minF = 9999999;
        while (!isConsistent) {
            isConsistent = true;
            maxF = -1;
            minF = 9999999;
            for (int e = ne_s; e <= ne_e; ++e) {
                for (int f = 0; f < flen; ++f) {
                    if (!this.a.aligned(f, e)) continue;
                    if (f > maxF) {
                        maxF = f;
                    }
                    if (f >= minF) continue;
                    minF = f;
                }
                if (maxF == -1) {
                    maxF = flen - 1;
                }
                if (minF != 9999999) continue;
                minF = 0;
            }
            for (int f = minF; f <= maxF; ++f) {
                for (int e = 0; e < elen; ++e) {
                    if (!this.a.aligned(f, e)) continue;
                    if (e > ne_e) {
                        ne_e = e;
                        isConsistent = false;
                    }
                    if (e >= ne_s) continue;
                    ne_s = e;
                    isConsistent = false;
                }
            }
        }
        return new SubPhraseCoordinates(ne_s, ne_e, minF, maxF);
    }

    public PhrasePair extractMinimalConsistentPhrasePairContainingESpan(int eStart, int eEnd) {
        SubPhraseCoordinates spc = this.getMinimalConsistentSubPhraseCoordsContainingESpan(eStart, eEnd);
        return this.extractSubPhrasePair(spc.f_start, spc.f_end, spc.e_start, spc.e_end);
    }

    public ArrayList<SubPhraseCoordinates> extractConsistentSubPhraseCoordinates(int maxPhraseLength) {
        ArrayList<SubPhraseCoordinates> res = new ArrayList<SubPhraseCoordinates>();
        int _elen = this.e.size();
        int _flen = this.f.size();
        if (!this.hasAlignment()) {
            throw new RuntimeException("Missing alignment");
        }
        int[] alignedCountF = new int[_flen];
        ArrayList alignedToE = new ArrayList();
        for (int i = 0; i < _elen; ++i) {
            alignedToE.add(new ArrayList());
        }
        for (Alignment.IntPair pair : this.a) {
            int f = pair.f;
            int e = pair.e;
            ((ArrayList)alignedToE.get(e)).add(f);
            int n = f;
            alignedCountF[n] = alignedCountF[n] + 1;
        }
        int[] usedF = new int[alignedCountF.length];
        for (int startE = 0; startE < _elen; ++startE) {
            for (int endE = startE; endE < _elen && endE < startE + maxPhraseLength; ++endE) {
                int maxF = -1;
                int minF = 9999999;
                System.arraycopy(alignedCountF, 0, usedF, 0, usedF.length);
                for (int ei = startE; ei <= endE; ++ei) {
                    ArrayList alignedToEi = (ArrayList)alignedToE.get(ei);
                    int naei = alignedToEi.size();
                    for (int i = 0; i < naei; ++i) {
                        int fi = (Integer)alignedToEi.get(i);
                        if (fi < minF) {
                            minF = fi;
                        }
                        if (fi > maxF) {
                            maxF = fi;
                        }
                        int n = fi;
                        usedF[n] = usedF[n] - 1;
                    }
                }
                if (maxF < 0 || maxF - minF >= maxPhraseLength) continue;
                boolean oob = false;
                for (int fi = minF; fi <= maxF && !oob; ++fi) {
                    if (usedF[fi] <= 0) continue;
                    oob = true;
                }
                if (oob) continue;
                for (int startF = minF; startF >= 0 && startF > maxF - maxPhraseLength && (startF == minF || alignedCountF[startF] == 0); --startF) {
                    for (int endF = maxF; endF < _flen && endF < startF + maxPhraseLength && (endF == maxF || alignedCountF[endF] == 0); ++endF) {
                        res.add(new SubPhraseCoordinates(startE, endE, startF, endF));
                    }
                }
            }
        }
        return res;
    }

    public ArrayList<PhrasePair> extractConsistentPhrasePairs(int maxPhraseLength) {
        ArrayList<SubPhraseCoordinates> pcl = this.extractConsistentSubPhraseCoordinates(maxPhraseLength);
        ArrayList<PhrasePair> res = new ArrayList<PhrasePair>(pcl.size());
        for (SubPhraseCoordinates spc : pcl) {
            res.add(this.extractSubPhrasePair(spc));
        }
        return res;
    }

    public static final class SubPhraseCoordinates {
        public int e_start;
        public int e_end;
        public int f_start;
        public int f_end;

        public SubPhraseCoordinates() {
        }

        public SubPhraseCoordinates(int es, int ee, int fs, int fe) {
            this.e_start = es;
            this.e_end = ee;
            this.f_start = fs;
            this.f_end = fe;
        }

        public String toString() {
            return "<(" + this.f_start + "," + this.f_end + ")-(" + this.e_start + "," + this.e_end + ")>";
        }
    }
}

