/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.hooka;

import edu.umd.hooka.VocabularyWritable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.hadoop.io.Text;

public class VocabServer
implements Runnable {
    ServerSocketChannel serverChannel;
    Selector selector = null;
    Text t = new Text();
    VocabularyWritable v = new VocabularyWritable();
    ByteBuffer out_bb = ByteBuffer.allocate(4);
    int i = 0;
    int connections = 0;
    HashMap<SelectionKey, ByteBuffer> key2buf = new HashMap();

    public static void main(String[] args) {
        try {
            VocabServer v = new VocabServer(4444);
            Thread t = new Thread(v);
            t.start();
            try {
                Thread.sleep(10000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            v.stopServer();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public VocabServer(int port) throws IOException {
        this.serverChannel = ServerSocketChannel.open();
        this.selector = Selector.open();
        this.serverChannel.socket().bind(new InetSocketAddress(port));
        this.serverChannel.configureBlocking(false);
        this.serverChannel.register(this.selector, 16);
        System.err.println("Vocab server initialized on port " + port);
    }

    public void stopServer() {
        System.err.println("Stopping server...");
        try {
            this.selector.close();
        }
        catch (Exception e) {
            System.err.println("Caught " + e);
        }
    }

    public void run() {
        System.err.println("Vocab server running...");
        block4: while (true) {
            try {
                this.selector.select();
            }
            catch (IOException e) {
                System.err.println("Caught exception in select()");
                e.printStackTrace();
                break;
            }
            if (!this.selector.isOpen()) break;
            Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
            while (true) {
                if (!it.hasNext()) continue block4;
                SelectionKey key = it.next();
                try {
                    this.processSelectionKey(key);
                }
                catch (IOException e) {
                    key.cancel();
                    System.err.println("Caught exception handling selection key. Key cancelled");
                }
                it.remove();
            }
            break;
        }
        System.err.println("Server exiting.");
        System.err.println("  " + (this.v.size() - 1) + " types processed");
        System.err.println("  " + this.connections + " connections");
    }

    protected void processSelectionKey(SelectionKey key) throws IOException {
        if (key.isAcceptable()) {
            ServerSocketChannel server = (ServerSocketChannel)key.channel();
            SocketChannel channel = server.accept();
            if (channel == null) {
                return;
            }
            channel.configureBlocking(false);
            channel.register(this.selector, 1);
            ++this.connections;
        } else if (key.isReadable()) {
            SocketChannel sc;
            int num;
            ByteBuffer in_bb = this.key2buf.get(key);
            if (in_bb == null) {
                System.err.println("Allocating new buffer!");
                in_bb = ByteBuffer.allocate(2048);
                this.key2buf.put(key, in_bb);
            }
            if ((num = (sc = (SocketChannel)key.channel()).read(in_bb)) == -1) {
                System.out.println("closing");
                this.key2buf.remove(key);
                sc.close();
                return;
            }
            byte elen = in_bb.get(0);
            if (elen < 1) {
                throw new RuntimeException("Elen is out of bounds! elen=" + elen);
            }
            int pl = in_bb.position();
            if (elen + 3 > pl) {
                return;
            }
            in_bb.flip();
            this.t.set(in_bb.array(), 2, in_bb.limit() - 2);
            this.i = this.v.addOrGet(this.t.toString());
            this.out_bb.putInt(this.i);
            this.out_bb.flip();
            int x = sc.write(this.out_bb);
            if (x != 4) {
                throw new IOException("Failed to write 4 bytes!");
            }
            in_bb.rewind();
            in_bb.limit(2048);
            this.out_bb.rewind();
        } else if (key.isWritable()) {
            throw new IOException("Received writable socket - not expecting!");
        }
    }
}

