/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.hooka.alignment;

import edu.umd.hooka.CorpusInfo;
import edu.umd.hooka.PhrasePair;
import edu.umd.hooka.alignment.IndexedFloatArray;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;

public class EFMarginalCounter {
    static CorpusInfo corpus = CorpusInfo.getCorpus(CorpusInfo.Corpus.ARABIC_5000k);

    public static void computeMarginals(Path bitext, Path outputPath, int mappers) throws IOException {
        int reduceTasks = 2;
        JobConf conf = new JobConf(EFMarginalCounter.class);
        conf.setJobName("EFMarginals");
        conf.setInputFormat(SequenceFileInputFormat.class);
        conf.setOutputKeyClass(IntWritable.class);
        conf.setOutputValueClass(IndexedFloatArray.class);
        conf.setMapperClass(MarginalMapper.class);
        conf.setReducerClass(MarginalReducer.class);
        conf.setNumMapTasks(mappers);
        conf.setNumReduceTasks(reduceTasks);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{corpus.getBitext()});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outputPath);
        conf.setOutputFormat(SequenceFileOutputFormat.class);
        JobClient.runJob((JobConf)conf);
    }

    public static void main(String[] args) throws IOException {
        JobConf conf = new JobConf(EFMarginalCounter.class);
        FileSystem fileSys = FileSystem.get((Configuration)conf);
        String sOutputPath = "marginals";
        Path outputPath = new Path(sOutputPath);
        fileSys.delete(outputPath);
        EFMarginalCounter.computeMarginals(corpus.getBitext(), outputPath, 38);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MarginalReducer
    extends MapReduceBase
    implements Reducer<IntWritable, IndexedFloatArray, IntWritable, IndexedFloatArray> {
        IntWritable oe = new IntWritable();

        public void reduce(IntWritable key, Iterator<IndexedFloatArray> values, OutputCollector<IntWritable, IndexedFloatArray> output, Reporter reporter) throws IOException {
            IndexedFloatArray sum = new IndexedFloatArray();
            while (values.hasNext()) {
                sum.plusEqualsMismatchSize(values.next());
            }
            output.collect((Object)key, (Object)sum);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MarginalMapper
    extends MapReduceBase
    implements Mapper<IntWritable, PhrasePair, IntWritable, IndexedFloatArray> {
        static final IntWritable emarginal = new IntWritable(0);
        static final IntWritable fmarginal = new IntWritable(1);
        OutputCollector<IntWritable, IndexedFloatArray> output_;
        float[] emap = new float[1000000];
        float[] fmap = new float[1000000];
        int maxF = -1;
        int maxE = -1;
        boolean hasValues = false;

        int[] makeUnique(int[] x) {
            int cur = -1;
            int c = 0;
            for (int i : x) {
                if (i == cur) continue;
                ++c;
                cur = i;
            }
            int[] res = new int[c];
            cur = -1;
            c = 0;
            for (int i : x) {
                if (i == cur) continue;
                res[c] = i;
                ++c;
                cur = i;
            }
            return res;
        }

        public void map(IntWritable key, PhrasePair value, OutputCollector<IntWritable, IndexedFloatArray> output, Reporter reporter) throws IOException {
            int i$;
            this.output_ = output;
            int[] es = value.getE().getWords();
            int[] fs = value.getF().getWords();
            Arrays.sort(es);
            Arrays.sort(fs);
            es = this.makeUnique(es);
            fs = this.makeUnique(fs);
            if (es[es.length - 1] > this.maxE) {
                this.maxE = es[es.length - 1];
            }
            if (fs[fs.length - 1] > this.maxF) {
                this.maxF = fs[fs.length - 1];
            }
            int[] arr$ = es;
            int len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                int e;
                int n = e = arr$[i$];
                this.emap[n] = this.emap[n] + 1.0f;
            }
            arr$ = fs;
            len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                int f;
                int n = f = arr$[i$];
                this.fmap[n] = this.fmap[n] + 1.0f;
            }
            this.hasValues = true;
        }

        public IndexedFloatArray makeIFA(float[] map, int max) {
            int c = 0;
            for (int i = 0; i <= max; ++i) {
                if (!(map[i] > 0.5f)) continue;
                ++c;
            }
            int[] ind = new int[c];
            float[] vals = new float[c];
            c = 0;
            for (int i = 0; i <= max; ++i) {
                if (!(map[i] > 0.5f)) continue;
                ind[c] = i;
                vals[c] = map[i];
                ++c;
            }
            return new IndexedFloatArray(ind, vals);
        }

        public void close() {
            try {
                if (this.hasValues) {
                    this.output_.collect((Object)emarginal, (Object)this.makeIFA(this.emap, this.maxE));
                    this.output_.collect((Object)fmarginal, (Object)this.makeIFA(this.fmap, this.maxF));
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Caught " + e);
            }
        }
    }
}

