/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.hooka.alignment;

import edu.umd.hooka.alignment.Digamma;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.hadoop.io.Writable;
import tl.lin.data.array.ArrayListOfInts;
import tl.lin.data.pair.PairOfFloatInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IndexedFloatArray
implements Writable,
Cloneable {
    public static final float NO_BINSEARCH_THRESHOLD = 0.9f;
    public static final int MIN_LENGTH_FOR_NONSPARSE_ARRAY = 5;
    public float[] _data;
    public int[] _indices;
    public boolean _useBinSearch;

    public void readFields(DataInput in) throws IOException {
        int bbLen = in.readInt();
        if (bbLen == 0) {
            this._data = null;
            this._indices = null;
            return;
        }
        ByteBuffer bb = ByteBuffer.allocate(bbLen);
        this._useBinSearch = in.readBoolean();
        if (this._useBinSearch) {
            in.readFully(bb.array());
            this._indices = new int[bbLen / 4];
            IntBuffer ib = bb.asIntBuffer();
            ib.get(this._indices);
            bb = ByteBuffer.allocate(bbLen);
        }
        in.readFully(bb.array());
        FloatBuffer fb = bb.asFloatBuffer();
        this._data = new float[bbLen / 4];
        fb.get(this._data);
    }

    public void write(DataOutput out) throws IOException {
        if (this._data == null) {
            out.writeInt(0);
        } else {
            int bbLen = this._data.length * 4;
            out.writeInt(bbLen);
            out.writeBoolean(this._useBinSearch);
            ByteBuffer bb = ByteBuffer.allocate(bbLen);
            if (this._useBinSearch) {
                IntBuffer ib = bb.asIntBuffer();
                ib.put(this._indices);
                out.write(bb.array());
                bb = ByteBuffer.allocate(bbLen);
            }
            FloatBuffer fb = bb.asFloatBuffer();
            fb.put(this._data);
            out.write(bb.array());
        }
    }

    public Object clone() {
        IndexedFloatArray res = new IndexedFloatArray();
        if (this._data == null) {
            return res;
        }
        res._data = (float[])this._data.clone();
        res._useBinSearch = this._useBinSearch;
        if (this._useBinSearch) {
            res._indices = (int[])this._indices.clone();
        }
        return res;
    }

    public int maxKey() {
        if (this._useBinSearch) {
            return this._indices[this._indices.length - 1];
        }
        return this._data.length - 1;
    }

    private void optimizeMemory(float[] data, int max) {
        if (this._useBinSearch) {
            return;
        }
        int nzc = 0;
        for (int c = 0; c < max; ++c) {
            if (data[c] == 0.0f) continue;
            ++nzc;
        }
        if (nzc == 0) {
            this._data = null;
            this._indices = null;
            return;
        }
        float[] nd = new float[nzc];
        int[] ni = new int[nzc];
        int ci = 0;
        for (int c = 0; c < max; ++c) {
            float v = data[c];
            if (v == 0.0f) continue;
            nd[ci] = v;
            ni[ci] = c;
            ++ci;
        }
        this._data = nd;
        this._indices = ni;
        this._useBinSearch = true;
    }

    public void optimizeSpeed() {
        if (this._indices == null || this._indices.length < 5) {
            return;
        }
        int maxIndex = this._indices[this._indices.length - 1];
        float load = (float)this._data.length / (float)maxIndex;
        if (load > 0.9f) {
            System.err.println("Optimizing IFA: len=" + this._indices.length + ", load=" + load + ", newMax=" + maxIndex);
            float[] nd = new float[maxIndex + 1];
            for (int i = 0; i < this._indices.length; ++i) {
                nd[this._indices[i]] = this._data[i];
            }
            this._data = nd;
            this._indices = null;
            this._useBinSearch = false;
        }
    }

    public void copyTo(float[] dest, int destPos) {
        System.arraycopy(this._data, 0, dest, destPos, this._data.length);
    }

    public void copyFrom(IndexedFloatArray rhs) {
        System.arraycopy(rhs._data, 0, this._data, 0, this._data.length);
    }

    public void addTo(float[] dest) {
        if (this._useBinSearch) {
            for (int i = 0; i < this._data.length; ++i) {
                int n = this._indices[i];
                dest[n] = dest[n] + this._data[i];
            }
        } else {
            for (int i = 0; i < this._data.length; ++i) {
                int n = i;
                dest[n] = dest[n] + this._data[i];
            }
        }
    }

    public IndexedFloatArray() {
    }

    public IndexedFloatArray(int[] indices, float[] values) {
        this._indices = indices;
        this._data = values;
        this._useBinSearch = true;
        this.optimizeSpeed();
    }

    public IndexedFloatArray(int[] indices, float[] values, boolean isOptimize) {
        this._indices = indices;
        this._data = values;
        this._useBinSearch = true;
        if (isOptimize) {
            this.optimizeSpeed();
        }
    }

    public IndexedFloatArray(float[] values, int size) {
        this._useBinSearch = false;
        int nzc = 0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == 0.0f) continue;
            ++nzc;
        }
        if (nzc == 0) {
            this._data = null;
            this._indices = null;
            return;
        }
        float load = (float)nzc / (float)size;
        if (size < 5 || load <= 0.9f) {
            this.optimizeMemory(values, size);
        } else {
            this._indices = null;
            this._data = new float[size];
            System.arraycopy(values, 0, this._data, 0, size);
        }
    }

    public IndexedFloatArray(int[] indices) {
        this._indices = (int[])indices.clone();
        this._data = new float[this._indices.length];
        this._useBinSearch = true;
    }

    public IndexedFloatArray(int n) {
        this._indices = null;
        this._useBinSearch = false;
        this._data = new float[n];
    }

    final int binSearch(int n) {
        if (!this._useBinSearch) {
            return n;
        }
        int min = 0;
        int max = this._indices.length - 1;
        while (min <= max) {
            int mid = (min + max) / 2;
            if (this._indices[mid] > n) {
                max = mid - 1;
                continue;
            }
            if (this._indices[mid] < n) {
                min = mid + 1;
                continue;
            }
            return mid;
        }
        throw new RuntimeException("IFA: Couldn't find " + n);
    }

    public int size() {
        if (this._data != null) {
            return this._data.length;
        }
        return 0;
    }

    public int getWord(int loc) {
        return this._indices[loc];
    }

    public float getProb(int loc) {
        return this._data[loc];
    }

    public final float get(int n) {
        if (this._data == null) {
            return 0.0f;
        }
        if (!this._useBinSearch) {
            if (n >= this._data.length) {
                return 0.0f;
            }
            return this._data[n];
        }
        int min = 0;
        int max = this._indices.length - 1;
        while (min <= max) {
            int mid = (min + max) / 2;
            if (this._indices[mid] > n) {
                max = mid - 1;
                continue;
            }
            if (this._indices[mid] < n) {
                min = mid + 1;
                continue;
            }
            return this._data[mid];
        }
        return 0.0f;
    }

    public final float getLazy(int n) {
        if (this._data == null) {
            return 0.0f;
        }
        for (int i = 0; i < this._indices.length; ++i) {
            if (this._indices[i] != n) continue;
            return this._data[i];
        }
        return 0.0f;
    }

    public int[] getTranslations(float probThreshold) {
        ArrayListOfInts words = new ArrayListOfInts();
        if (this._useBinSearch) {
            for (int i = 0; i < this._data.length; ++i) {
                if (!(this._data[i] > probThreshold)) continue;
                words.add(this._indices[i]);
            }
        } else {
            for (int i = 0; i < this._data.length; ++i) {
                if (!(this._data[i] > probThreshold)) continue;
                words.add(i);
            }
        }
        words.trimToSize();
        return words.getArray();
    }

    public PriorityQueue<PairOfFloatInt> getTranslationsWithProbs(float probThreshold) {
        PriorityQueue<PairOfFloatInt> q = new PriorityQueue<PairOfFloatInt>(this._data.length, Collections.reverseOrder());
        if (this._useBinSearch) {
            for (int i = 0; i < this._data.length; ++i) {
                if (!(this._data[i] > probThreshold)) continue;
                q.add(new PairOfFloatInt(this._data[i], this._indices[i]));
            }
        } else {
            for (int i = 0; i < this._data.length; ++i) {
                if (!(this._data[i] > probThreshold)) continue;
                q.add(new PairOfFloatInt(this._data[i], i));
            }
        }
        return q;
    }

    public List<PairOfFloatInt> getTranslationsWithProbsAsList(float probThreshold) {
        ArrayList<PairOfFloatInt> l = new ArrayList<PairOfFloatInt>();
        if (this._useBinSearch) {
            for (int i = 0; i < this._data.length; ++i) {
                if (!(this._data[i] > probThreshold)) continue;
                l.add(new PairOfFloatInt(this._data[i], this._indices[i]));
            }
        } else {
            for (int i = 0; i < this._data.length; ++i) {
                if (!(this._data[i] > probThreshold)) continue;
                l.add(new PairOfFloatInt(this._data[i], i));
            }
        }
        return l;
    }

    public final void set(int index, float value) {
        this._data[this.binSearch((int)index)] = value;
    }

    public final void add(int index, float delta) {
        int n = this.binSearch(index);
        this._data[n] = this._data[n] + delta;
    }

    public int getAddr(int index) {
        return this.binSearch(index);
    }

    public void clear() {
        int l = this.size();
        for (int i = 0; i < l; ++i) {
            this._data[i] = 0.0f;
        }
    }

    public void plusEqualsMismatchSize(IndexedFloatArray rhs) {
        int dif;
        if (this._data == null) {
            if (rhs._data == null) {
                return;
            }
            this._data = (float[])rhs._data.clone();
            if (rhs._indices != null) {
                this._indices = (int[])rhs._indices.clone();
            }
            this._useBinSearch = rhs._useBinSearch;
            return;
        }
        this.optimizeMemory(this._data, this._data.length);
        rhs.optimizeMemory(rhs._data, rhs._data.length);
        float[] tv = new float[this._data.length + rhs._data.length];
        int[] tk = new int[this._data.length + rhs._data.length];
        int cl = 0;
        int cr = 0;
        int c = 0;
        while (cl < this._data.length && cr < rhs._data.length) {
            int il = this._indices[cl];
            int ir = rhs._indices[cr];
            if (il == ir) {
                tk[c] = ir;
                tv[c] = this._data[cl] + rhs._data[cr];
                ++cr;
                ++cl;
            } else if (il < ir) {
                tk[c] = il;
                tv[c] = this._data[cl];
                ++cl;
            } else {
                tk[c] = ir;
                tv[c] = rhs._data[cr];
                ++cr;
            }
            ++c;
        }
        if (cl < this._data.length) {
            dif = this._data.length - cl;
            System.arraycopy(this._data, cl, tv, c, dif);
            System.arraycopy(this._indices, cl, tk, c, dif);
            c += dif;
        } else if (cr < rhs._data.length) {
            dif = rhs._data.length - cr;
            System.arraycopy(rhs._data, cr, tv, c, dif);
            System.arraycopy(rhs._indices, cr, tk, c, dif);
            c += dif;
        }
        if (c == tv.length) {
            this._data = tv;
            this._indices = tk;
        } else {
            int[] ni = new int[c];
            float[] nv = new float[c];
            System.arraycopy(tk, 0, ni, 0, c);
            System.arraycopy(tv, 0, nv, 0, c);
            this._data = nv;
            this._indices = ni;
            this.optimizeSpeed();
        }
    }

    public void plusEquals(IndexedFloatArray rhs) {
        if (this.size() != rhs.size()) {
            throw new RuntimeException("Size mismatch");
        }
        if (this.size() == 0) {
            return;
        }
        for (int i = 0; i < this._data.length; ++i) {
            int n = i;
            this._data[n] = this._data[n] + rhs._data[i];
        }
    }

    public void minusEquals(IndexedFloatArray rhs) {
        if (this.size() != rhs.size()) {
            throw new RuntimeException("Size mismatch");
        }
        if (this.size() == 0) {
            return;
        }
        for (int i = 0; i < this._data.length; ++i) {
            int n = i;
            this._data[n] = this._data[n] - rhs._data[i];
        }
    }

    public void timesEquals(float rhs) {
        if (this.size() == 0) {
            return;
        }
        int i = 0;
        while (i < this._data.length) {
            int n = i++;
            this._data[n] = this._data[n] * rhs;
        }
    }

    public void normalize() {
        this.normalize(0.0f);
    }

    public void normalize(float alpha) {
        if (this.size() == 0) {
            return;
        }
        float total = 0.0f;
        for (float f : this._data) {
            total += f + alpha;
        }
        if (total == 0.0f) {
            float v = 1.0f / (float)this.size();
            for (int i = 0; i < this._data.length; ++i) {
                this._data[i] = v;
            }
        } else {
            for (int i = 0; i < this._data.length; ++i) {
                this._data[i] = (this._data[i] + alpha) / total;
            }
        }
    }

    public void normalize_variationalBayes(float alpha) {
        if (this.size() == 0) {
            return;
        }
        float total = 0.0f;
        for (float f : this._data) {
            total += f + alpha;
        }
        if (total == 0.0f) {
            throw new RuntimeException("Sum=0: shouldn't happen " + this);
        }
        for (int i = 0; i < this._data.length; ++i) {
            this._data[i] = (float)Math.exp(Digamma.digamma(this._data[i] + alpha) - Digamma.digamma(total));
        }
    }

    public float innerProduct(IndexedFloatArray rhs) {
        if (this.size() != rhs.size()) {
            throw new RuntimeException("Size mismatch");
        }
        if (this.size() == 0) {
            return 0.0f;
        }
        float res = 0.0f;
        for (int i = 0; i < this._data.length; ++i) {
            res += this._data[i] * rhs._data[i];
        }
        return res;
    }

    public String toString(boolean brackets) {
        StringBuffer sb = new StringBuffer();
        if (brackets) {
            sb.append('<');
        }
        if (this._data == null) {
            sb.append("null");
        } else if (this._useBinSearch) {
            if (this.size() > 0) {
                for (int i = 0; i < this._data.length; ++i) {
                    if (i != 0) {
                        sb.append(' ');
                    }
                    sb.append(this._indices[i] + ":" + this._data[i]);
                }
            }
        } else {
            for (int i = 0; i < this._data.length; ++i) {
                if (i != 0) {
                    sb.append(' ');
                }
                sb.append(i + ":" + this._data[i]);
            }
        }
        if (brackets) {
            sb.append('>');
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(true);
    }
}

