/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.hooka.alignment;

import edu.umd.hooka.Alignment;
import edu.umd.hooka.PhrasePair;
import edu.umd.hooka.alignment.CrossEntropyCounters;
import edu.umd.hooka.alignment.PerplexityReporter;
import edu.umd.hooka.alignment.model1.Model1;
import edu.umd.hooka.ttables.TTable;
import edu.umd.hooka.ttables.TTable_monolithic_IFAs;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.SequenceFileInputFormat;

public class M1ViterbiExtract {
    static final String bitext = "/shared/bitexts/hansards.fr-en/hansards.aachen.bitext";
    static final String ttable = "/user/redpony/hansards.aachen.ttable";

    protected static TTable loadTTable(Path path) throws IOException {
        Configuration conf = new Configuration();
        FileSystem fileSys = FileSystem.get((Configuration)conf);
        DataInputStream in = new DataInputStream(new BufferedInputStream((InputStream)fileSys.open(path)));
        TTable_monolithic_IFAs tt = new TTable_monolithic_IFAs();
        tt.readFields(in);
        return tt;
    }

    public static void main(String[] args) throws IOException {
        int mapTasks = 15;
        JobConf conf = new JobConf(M1ViterbiMapper.class);
        conf.setJobName("m1viterbi");
        conf.setOutputKeyClass(LongWritable.class);
        conf.setOutputValueClass(Text.class);
        conf.setMapperClass(M1ViterbiMapper.class);
        conf.setNumMapTasks(mapTasks);
        conf.setNumReduceTasks(0);
        conf.setInputFormat(SequenceFileInputFormat.class);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{new Path(bitext)});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)new Path("somealigns.test"));
        RunningJob rj = JobClient.runJob((JobConf)conf);
        Counters cs = rj.getCounters();
        double lp = cs.getCounter((Enum)CrossEntropyCounters.LOGPROB);
        double wc = cs.getCounter((Enum)CrossEntropyCounters.WORDCOUNT);
        double ce = lp / wc / Math.log(2.0);
        System.out.println("Viterbi cross-entropy: " + ce + "   perplexity: " + Math.pow(2.0, ce));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class M1ViterbiMapper
    extends MapReduceBase
    implements Mapper<IntWritable, PhrasePair, IntWritable, Text> {
        Text out = new Text();
        PerplexityReporter cr = new PerplexityReporter();
        Model1 m1 = null;

        public void map(IntWritable key, PhrasePair value, OutputCollector<IntWritable, Text> output, Reporter reporter) throws IOException {
            if (this.m1 == null) {
                Path pathTTable = new Path(M1ViterbiExtract.ttable);
                TTable tt = M1ViterbiExtract.loadTTable(pathTTable);
                this.m1 = new Model1(tt, true);
            }
            this.cr.reset();
            Alignment a = this.m1.viterbiAlign(value, this.cr);
            this.out.set(a.toString());
            output.collect((Object)key, (Object)this.out);
            reporter.incrCounter((Enum)CrossEntropyCounters.LOGPROB, (long)this.cr.getTotalLogProb());
            reporter.incrCounter((Enum)CrossEntropyCounters.WORDCOUNT, (long)this.cr.getTotalWordCount());
        }

        public void close() {
        }
    }
}

