/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.hooka.alignment.aer;

import edu.umd.hooka.Alignment;
import java.io.BufferedReader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;

public class ReferenceAlignment
extends Alignment {
    Alignment.M2 _sureAligned;

    public ReferenceAlignment() {
        this._sureAligned = new Alignment.M2();
    }

    public ReferenceAlignment(int flen, int elen) {
        super(flen, elen);
        this._sureAligned = new Alignment.M2(flen, elen);
    }

    public byte getType() {
        return 2;
    }

    public void sureAlign(int f, int e) {
        super.align(f, e);
        this._sureAligned.set(f, e);
    }

    public void probableAlign(int f, int e) {
        super.align(f, e);
    }

    public boolean isSureAligned(int f, int e) {
        return this._sureAligned.get(f, e);
    }

    public boolean isProbableAligned(int f, int e) {
        return super.aligned(f, e);
    }

    public int countProbableHits(Alignment test) {
        int hits = 0;
        int fl = Math.min(this._flen, test.getFLength());
        int el = Math.min(this._elen, test.getELength());
        for (int j = 0; j < fl; ++j) {
            for (int i = 0; i < el; ++i) {
                if (!this.aligned(j, i) || !test.aligned(j, i)) continue;
                ++hits;
            }
        }
        return hits;
    }

    public int countSureHits(Alignment test) {
        if (this._flen != test.getFLength() || this._elen != test.getELength()) {
            throw new RuntimeException("Reference is larger than source! " + this._elen + "," + this._flen + "  " + test.getELength() + "," + test.getFLength());
        }
        int hits = 0;
        int fl = Math.min(this._flen, test.getFLength());
        int el = Math.min(this._elen, test.getELength());
        for (int j = 0; j < fl; ++j) {
            for (int i = 0; i < el; ++i) {
                if (!test.aligned(j, i) || !this.isSureAligned(j, i)) continue;
                ++hits;
            }
        }
        return hits;
    }

    public int countSureAlignmentPoints() {
        int count = 0;
        for (int j = 0; j < this._flen; ++j) {
            for (int i = 0; i < this._elen; ++i) {
                if (!this.isSureAligned(j, i)) continue;
                ++count;
            }
        }
        return count;
    }

    public Alignment getTranspose() {
        ReferenceAlignment ra = new ReferenceAlignment(this._elen, this._flen);
        for (int ei = 0; ei < this._elen; ++ei) {
            for (int fi = 0; fi < this._flen; ++fi) {
                if (this.isProbableAligned(fi, ei)) {
                    ra.probableAlign(ei, fi);
                }
                if (!this.isSureAligned(fi, ei)) continue;
                ra.sureAlign(ei, fi);
            }
        }
        return ra;
    }

    public void addAlignmentPointsPharaoh(String p) {
        String[] aps;
        for (String ap : aps = p.split("\\s+")) {
            String[] ef;
            boolean probable;
            if (ap.length() == 0) continue;
            boolean bl = probable = ap.charAt(0) == '?';
            if (probable) {
                ap = ap.substring(1);
            }
            if ((ef = ap.split("-")).length != 2) {
                throw new RuntimeException("Invalid format: " + ap);
            }
            int f = Integer.parseInt(ef[0]);
            int e = Integer.parseInt(ef[1]);
            if (probable) {
                this.probableAlign(f, e);
                continue;
            }
            this.sureAlign(f, e);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this._flen; ++i) {
            for (int j = 0; j < this._elen; ++j) {
                if (this.isSureAligned(i, j)) {
                    sb.append(i).append('-').append(j).append(' ');
                    continue;
                }
                if (!this.isProbableAligned(i, j)) continue;
                sb.append('?').append(i).append('-').append(j).append(' ');
            }
        }
        if (sb.length() > 0) {
            sb.delete(sb.length() - 1, sb.length());
        }
        return sb.toString();
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this._sureAligned.readFields(in);
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        this._sureAligned.write(out);
    }

    public static WPTFileReader getWPT03FileIterator(InputStream is) throws IOException {
        return new WPTFileReader(is);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class WPTFileReader
    implements Iterator<ReferenceAlignment> {
        int maxE = -1;
        int maxF = -1;
        BufferedReader br = null;
        int cur = -1;
        String line = null;
        ArrayList<EFSTriple> aps = null;
        int blanks = 0;

        public WPTFileReader(InputStream in) throws IOException {
            this.br = new BufferedReader(new InputStreamReader(in));
            this.line = this.br.readLine();
            this.aps = new ArrayList();
        }

        @Override
        public boolean hasNext() {
            return this.line != null;
        }

        /*
         * Exception decompiling
         */
        @Override
        public ReferenceAlignment next() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 12[SIMPLE_IF_TAKEN]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    }

    static class EFSTriple {
        int e;
        int f;
        boolean sure;

        public EFSTriple(int e, int f, boolean sure) {
            this.e = e;
            this.f = f;
            this.sure = sure;
        }
    }
}

