/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.hooka.alignment.hmm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.apache.hadoop.io.Writable;

public class ATable
implements Writable,
Cloneable {
    float[][] data;
    float _nullTrans;
    int maxDist;
    boolean modelNull;
    int extraIPrevFactors;
    int extraIFactors;
    boolean homogeneous = true;

    public Object clone() {
        ATable r = new ATable(this.homogeneous, this.data.length, this.maxDist);
        r._nullTrans = this._nullTrans;
        for (int i = 0; i < this.data.length; ++i) {
            System.arraycopy(this.data[i], 0, r.data[i], 0, this.data[i].length);
        }
        return r;
    }

    public void clear() {
        for (int i = 0; i < this.data.length; ++i) {
            float[] row = this.data[i];
            for (int j = 0; j < row.length; ++j) {
                row[j] = 0.0f;
            }
        }
        this._nullTrans = 0.0f;
    }

    public ATable() {
    }

    public ATable(boolean homo, int conditioning_values, int dist) {
        this.maxDist = dist;
        this.homogeneous = homo;
        this.modelNull = false;
        this.extraIPrevFactors = 0;
        this.extraIFactors = 0;
        if (this.homogeneous) assert (conditioning_values == 1);
        this.data = new float[conditioning_values][];
        for (int i = 0; i < conditioning_values; ++i) {
            this.data[i] = this.homogeneous ? new float[this.maxDist * 2 + 1] : new float[i * 2 + 1];
        }
    }

    public final int getMaxDist() {
        return this.maxDist;
    }

    public float get(int jump, char condition) {
        if (jump == -1000) {
            return this._nullTrans;
        }
        try {
            if (this.homogeneous) {
                return this.data[0][jump + this.maxDist];
            }
            return this.data[condition][jump + condition];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new RuntimeException("Tried access: " + jump + "+" + this.maxDist + " but dl=" + this.data.length + "  Caught " + e);
        }
    }

    public float get(int jump, char condition, int dummy) {
        if (jump == -1000) {
            return this._nullTrans;
        }
        try {
            if (this.homogeneous) {
                return this.data[0][jump];
            }
            return this.data[condition][jump];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return 0.0f;
        }
    }

    public void add(int jump, char condition, int dummy, float v) {
        if (v == 0.0f) {
            return;
        }
        if (jump == -1000) {
            this._nullTrans += v;
        } else if (this.homogeneous) {
            float[] fArray = this.data[0];
            int n = jump + this.maxDist;
            fArray[n] = fArray[n] + v;
        } else {
            float[] fArray = this.data[condition];
            int n = jump + condition;
            fArray[n] = fArray[n] + v;
        }
    }

    public void add(int coord, char condition, float v) {
        if (v == 0.0f) {
            return;
        }
        if (coord == -1000) {
            this._nullTrans += v;
        } else if (this.homogeneous) {
            float[] fArray = this.data[0];
            int n = coord;
            fArray[n] = fArray[n] + v;
        } else {
            float[] fArray = this.data[condition];
            int n = coord;
            fArray[n] = fArray[n] + v;
        }
    }

    public int getCoord(int jump, char condition) {
        if (this.homogeneous) {
            if (jump == -1000) {
                return jump;
            }
            return jump + this.maxDist;
        }
        if (jump == -1000) {
            return jump;
        }
        return jump + condition;
    }

    public void plusEquals(ATable rhs) {
        if (this.data.length != rhs.data.length) {
            throw new RuntimeException("mismatch lengths!");
        }
        for (int i = 0; i < this.data.length; ++i) {
            float[] row = this.data[i];
            float[] orow = rhs.data[i];
            assert (row.length == orow.length);
            for (int j = 0; j < row.length; ++j) {
                int n = j;
                row[n] = row[n] + orow[j];
            }
        }
        this._nullTrans += rhs._nullTrans;
    }

    public void normalize() {
        boolean smooth = true;
        float alpha = 1.0E-5f;
        boolean renorm = false;
        for (float[] row : this.data) {
            float sum = 0.0f;
            if (this.modelNull) {
                sum = this._nullTrans;
            }
            for (float v : row) {
                sum += v;
            }
            if (sum > 0.0f) {
                int i;
                if (smooth) {
                    this._nullTrans = this.modelNull ? (this._nullTrans + alpha) / (sum += alpha * (float)(row.length + 1)) : 0.0f;
                    for (i = 0; i < row.length; ++i) {
                        row[i] = (row[i] + alpha) / sum;
                    }
                    continue;
                }
                this._nullTrans /= sum;
                i = 0;
                while (i < this.data.length) {
                    int n = i++;
                    row[n] = row[n] / sum;
                }
                continue;
            }
            boolean initializeUniform = false;
            renorm = true;
            if (initializeUniform) {
                float up = 1.0f / (float)(row.length + 1);
                for (int i = 0; i < row.length; ++i) {
                    row[i] = up;
                }
                if (this.modelNull) {
                    this._nullTrans = up;
                    continue;
                }
                this._nullTrans = 0.0f;
                continue;
            }
            for (int i = 0; i < row.length; ++i) {
                int len = (row.length - 1) / 2;
                int ad = 0;
                ad = this.homogeneous ? i - this.maxDist - 1 : i - len - 1;
                if (ad > 0) {
                    ad *= -1;
                }
                if (this.homogeneous) {
                    if (i - this.maxDist == 0) {
                        ad -= 3;
                    }
                } else if (i - len == 0 && i > 3) {
                    ad -= 3;
                }
                row[i] = (float)Math.exp((double)ad * 0.15);
            }
            if (this.modelNull & !this.homogeneous) {
                throw new RuntimeException("Not implemented properly");
            }
            this._nullTrans = this.modelNull ? row[row.length / 2] : 0.0f;
        }
        if (renorm) {
            this.normalize();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ATable: maxDist=").append(this.maxDist).append('\n');
        int i = -1;
        for (float[] row : this.data) {
            sb.append("cond=").append(++i);
            sb.append("     NULL-trans=").append(this._nullTrans).append('\n');
            int md = i;
            if (this.homogeneous) {
                md = this.maxDist;
            }
            for (int j = 0; j < row.length; ++j) {
                sb.append(" P(J=").append(j - md).append(") = ").append(row[j]).append('\t');
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public void readFields(DataInput in) throws IOException {
        this.homogeneous = in.readBoolean();
        this.maxDist = in.readInt();
        this.data = new float[in.readInt()][];
        for (int i = 0; i < this.data.length; ++i) {
            int bbLen = in.readInt();
            ByteBuffer bb = ByteBuffer.allocate(bbLen);
            in.readFully(bb.array());
            FloatBuffer fb = bb.asFloatBuffer();
            this.data[i] = new float[bbLen / 4];
            fb.get(this.data[i]);
        }
        this._nullTrans = in.readFloat();
    }

    public void write(DataOutput out) throws IOException {
        out.writeBoolean(this.homogeneous);
        out.writeInt(this.maxDist);
        out.writeInt(this.data.length);
        for (int i = 0; i < this.data.length; ++i) {
            int bbLen = this.data[i].length * 4;
            out.writeInt(bbLen);
            ByteBuffer bb = ByteBuffer.allocate(bbLen);
            FloatBuffer fb = bb.asFloatBuffer();
            fb.put(this.data[i], 0, this.data[i].length);
            out.write(bb.array());
        }
        out.writeFloat(this._nullTrans);
    }
}

