/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.hooka.alignment.hmm;

import java.util.Arrays;

public final class IntArray2D {
    int[] data;
    int width;
    int size;

    public IntArray2D(int maxCap) {
        this.data = new int[maxCap];
    }

    public void resize(int x, int y) {
        int s = x * y;
        if (s > this.data.length) {
            throw new RuntimeException("Requested size larger than allocated space");
        }
        this.size = s;
        this.width = x;
        this.fill(0);
    }

    public void fill(int val) {
        Arrays.fill(this.data, 0, this.size, val);
    }

    public int get(int x, int y) {
        return this.data[y * this.width + x];
    }

    public void set(int x, int y, int v) {
        this.data[y * this.width + x] = v;
    }

    public int getSize1() {
        return this.width;
    }

    public int getSize2() {
        return this.size / this.width;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int r = this.getSize2();
        int c = this.getSize1();
        for (int j = 0; j < r; ++j) {
            for (int i = 0; i < c; ++i) {
                sb.append("  ").append(this.get(i, j));
            }
            sb.append('\n');
        }
        return sb.toString();
    }
}

