/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.hooka.alignment.model1;

import edu.umd.hooka.Int2FloatMap;
import edu.umd.hooka.PhrasePair;
import edu.umd.hooka.alignment.AlignmentModel;
import edu.umd.hooka.alignment.PartialCountContainer;
import edu.umd.hooka.ttables.TTable;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapred.OutputCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Model1Base
extends AlignmentModel {
    protected final int maxF = 214350;
    protected boolean _includeEnglishNullWord = true;
    TreeMap<IntWritable, Int2FloatMap> counts = new TreeMap();
    IntWritable nullWord = new IntWritable(0);
    FloatWritable[] tcmap = null;
    int width = 0;

    public Model1Base(boolean incNullWord) {
        this._includeEnglishNullWord = incNullWord;
    }

    @Override
    public void writePartialCounts(OutputCollector<IntWritable, PartialCountContainer> output) throws IOException {
        PartialCountContainer pcc = new PartialCountContainer();
        Iterator<Map.Entry<IntWritable, Int2FloatMap>> i = this.counts.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<IntWritable, Int2FloatMap> p = i.next();
            pcc.setContent(p.getValue().getAsIndexedFloatArray());
            output.collect((Object)p.getKey(), (Object)pcc);
            i.remove();
        }
    }

    public void addPartialTranslationCountsToTTable(TTable tcounts) {
        Iterator<Map.Entry<IntWritable, Int2FloatMap>> i = this.counts.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<IntWritable, Int2FloatMap> p = i.next();
            int ei = p.getKey().get();
            for (Map.Entry<Integer, FloatWritable> f : p.getValue().entrySet()) {
                tcounts.add(ei, f.getKey(), f.getValue().get());
            }
            i.remove();
        }
    }

    protected void initializeCountTableForSentencePair(PhrasePair pp) {
        int[] ew = pp.getE().getWords();
        int[] fw = pp.getF().getWords();
        this.width = fw.length;
        this.tcmap = new FloatWritable[(ew.length + 1) * fw.length];
        int c = 0;
        Int2FloatMap ecm = null;
        if (this._includeEnglishNullWord) {
            ecm = this.counts.get(this.nullWord);
            if (ecm == null) {
                ecm = new Int2FloatMap();
                this.counts.put(this.nullWord, ecm);
            }
            for (int fi : fw) {
                ecm.createIfMissing(fi);
                this.tcmap[c] = ecm.getFloatWritable(fi);
                ++c;
            }
        } else {
            c += fw.length;
        }
        for (int ei : ew) {
            IntWritable cew = new IntWritable(ei);
            ecm = this.counts.get(cew);
            if (ecm == null) {
                ecm = new Int2FloatMap();
                this.counts.put(cew, ecm);
            }
            for (int fi : fw) {
                ecm.createIfMissing(fi);
                this.tcmap[c] = ecm.getFloatWritable(fi);
                ++c;
            }
        }
    }

    protected final int getTranslationCoord(int i_plus1, int j) {
        return i_plus1 * this.width + j;
    }

    protected final void addTranslationCount(int i_plus1, int j, float v) {
        if (v == 0.0f) {
            return;
        }
        int coord = this.getTranslationCoord(i_plus1, j);
        if (this.tcmap[coord] == null) {
            throw new RuntimeException("isNull(" + i_plus1 + "," + j + ")");
        }
        this.tcmap[coord].set(this.tcmap[coord].get() + v);
    }

    protected final void addTranslationCount(int coord, float v) {
        if (v == 0.0f) {
            return;
        }
        this.tcmap[coord].set(this.tcmap[coord].get() + v);
    }
}

