/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.hooka.corpora;

import edu.umd.hooka.corpora.Language;
import java.util.HashMap;

public class LanguagePair {
    private Language source;
    private Language target;
    static HashMap<String, LanguagePair> lpmap = new HashMap();

    public static LanguagePair languageForISO639_1Pair(String s) {
        if (!s.matches("^[a-z]{2}-[a-z]{2}$")) {
            throw new RuntimeException("Bad format for language pair: " + s);
        }
        LanguagePair lp = lpmap.get(s);
        if (lp != null) {
            return lp;
        }
        lp = new LanguagePair(s);
        lpmap.put(s, lp);
        return lp;
    }

    public int hashCode() {
        return this.source.hashCode() * 31 + this.target.hashCode() + 11;
    }

    private LanguagePair(String s) {
        this.source = Language.languageForISO639_1(s.substring(0, 2));
        this.target = Language.languageForISO639_1(s.substring(3));
    }

    public LanguagePair inverted() {
        return LanguagePair.languageForISO639_1Pair(this.target.code() + "-" + this.source.code());
    }

    public final boolean isRelevant(Language l) {
        return l == this.source || l == this.target;
    }

    public String toString() {
        return this.source.code() + "-" + this.target.code();
    }

    public final Language getSource() {
        return this.source;
    }

    public final Language getTarget() {
        return this.target;
    }
}

