/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.hooka.corpora;

import edu.umd.hooka.alignment.aer.ReferenceAlignment;
import edu.umd.hooka.corpora.Chunk;
import edu.umd.hooka.corpora.Language;
import edu.umd.hooka.corpora.LanguagePair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ParallelChunk {
    public HashMap<Language, Chunk> l2c = new HashMap();
    public HashMap<LanguagePair, ReferenceAlignment> lp2ra = null;
    public String name;

    public static final String escape(String s) {
        return s.replaceAll("\\&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public void addChunk(Language l, Chunk c) {
        if (this.l2c.containsKey(l)) {
            throw new RuntimeException("PChunk " + this + " already contains language " + l);
        }
        this.l2c.put(l, c);
    }

    public void addReferenceAlignment(LanguagePair lp, ReferenceAlignment r) {
        if (this.lp2ra == null) {
            this.lp2ra = new HashMap(1);
        }
        this.lp2ra.put(lp, r);
    }

    public ReferenceAlignment getReferenceAlignment(LanguagePair lp) {
        if (this.lp2ra == null) {
            return null;
        }
        ReferenceAlignment r = this.lp2ra.get(lp);
        if (r == null && (r = this.lp2ra.get(lp.inverted())) != null) {
            r = (ReferenceAlignment)r.getTranspose();
            this.lp2ra.put(lp, r);
        }
        return r;
    }

    public final Chunk getChunk(Language l) {
        return this.l2c.get(l);
    }

    public String toString() {
        ArrayList<Integer> lens = new ArrayList<Integer>();
        for (Chunk c : this.l2c.values()) {
            lens.add(c.getLength());
        }
        return "PChunk<langs=" + this.l2c.keySet() + " chunk lengths (words)=" + lens + (this.lp2ra == null ? "" : " refaligns=" + this.lp2ra.keySet()) + ">";
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return (this.lp2ra == null ? 0 : this.lp2ra.hashCode() * 31) + this.l2c.hashCode();
    }

    public final String idString() {
        long l = 1L;
        for (Map.Entry<Language, Chunk> entry : this.l2c.entrySet()) {
            l *= 31L;
            l += (long)(entry.getKey().hashCode() * 17);
            l += (long)entry.getValue().hashCode();
        }
        if (this.lp2ra != null) {
            for (Map.Entry<Object, Object> entry : this.lp2ra.entrySet()) {
                l *= 29L;
                l += (long)((LanguagePair)entry.getKey()).hashCode();
            }
        }
        return Long.toString(l, 36) + "_" + this.name;
    }

    public String toXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<pchunk");
        if (this.name != null) {
            sb.append(" name=\"").append(this.name).append('\"');
        }
        sb.append(">\n");
        for (Map.Entry<Language, Chunk> entry : this.l2c.entrySet()) {
            sb.append("  <s lang=\"").append(entry.getKey().code());
            sb.append("\"> ").append(ParallelChunk.escape(entry.getValue().toString())).append(" </s>\n");
        }
        if (this.lp2ra != null) {
            for (Map.Entry<Object, Object> entry : this.lp2ra.entrySet()) {
                sb.append("  <wordalignment langpair=\"").append(entry.getKey());
                sb.append("\"> ").append(entry.getValue()).append(" </wordalignment>\n");
            }
        }
        sb.append("</pchunk>\n");
        return sb.toString();
    }
}

