/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.hooka.ttables;

import edu.umd.hooka.alignment.IndexedFloatArray;
import edu.umd.hooka.ttables.TTable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class TTable_monolithic
extends TTable
implements Cloneable {
    int[] _ef;
    int[] _e;
    float[] _values;
    IndexedFloatArray _nullValues;
    Path _datapath;
    FileSystem _fs;
    private static final Logger myLogger = Logger.getLogger(TTable_monolithic.class);
    int eLen;
    int indexLen;

    public Object clone() {
        TTable_monolithic res = new TTable_monolithic();
        res._ef = (int[])this._ef.clone();
        res._e = (int[])this._e.clone();
        res._values = (float[])this._values.clone();
        res.eLen = this.eLen;
        res.indexLen = this.indexLen;
        res._nullValues = (IndexedFloatArray)this._nullValues.clone();
        return res;
    }

    public TTable_monolithic() {
    }

    public TTable_monolithic(FileSystem fs, Path p) throws IOException {
        this._fs = fs;
        this._datapath = p;
        this.readFields((DataInput)this._fs.open(this._datapath));
    }

    public TTable_monolithic(int[] e, int[] ef, int maxF) {
        this._ef = ef;
        this._e = e;
        this._nullValues = new IndexedFloatArray(maxF + 1);
        this.eLen = this._e.length;
        this.indexLen = this._ef.length;
        this._values = new float[this.indexLen];
    }

    public TTable_monolithic(int[] e, int[] ef, int maxF, FileSystem fs, Path p) {
        this._ef = ef;
        this._e = e;
        this._nullValues = new IndexedFloatArray(maxF + 1);
        this.eLen = this._e.length;
        this.indexLen = this._ef.length;
        this._values = new float[this.indexLen];
        this._fs = fs;
        this._datapath = p;
    }

    public int getMaxF() {
        return this._nullValues.size() - 1;
    }

    public int getMaxE() {
        return this._e.length - 1;
    }

    int binSearch(int e, int f) {
        int min = this._e[e];
        int max = this._e[e + 1] - 1;
        while (min <= max) {
            int mid = (min + max) / 2;
            if (this._ef[mid] > f) {
                max = mid - 1;
                continue;
            }
            if (this._ef[mid] < f) {
                min = mid + 1;
                continue;
            }
            return mid;
        }
        throw new RuntimeException("Couldn't find (" + f + "," + e + ")");
    }

    public void add(int e, int f, float delta) {
        if (e == 0) {
            this._nullValues.add(f, delta);
        } else {
            int n = this.binSearch(e, f);
            this._values[n] = this._values[n] + delta;
        }
    }

    public void set(int e, int f, float value) {
        if (e == 0) {
            this._nullValues.set(f, value);
        } else {
            this._values[this.binSearch((int)e, (int)f)] = value;
        }
    }

    public void setDistribution(float[] x) {
        this._values = (float[])x.clone();
    }

    public void setNullDistribution(float[] x) {
        myLogger.setLevel(Level.DEBUG);
        myLogger.debug((Object)("Length of input array is " + x.length));
        this._nullValues = new IndexedFloatArray(x.length);
        this._nullValues.set(0, 0.0f);
        for (int i = 1; i < x.length; ++i) {
            this._nullValues.set(i, x[i]);
        }
    }

    public void set(int e, IndexedFloatArray fs) {
        if (e == 0) {
            this._nullValues.copyFrom(fs);
            return;
        }
        int from = this._e[e];
        int len = this._e[e + 1] - from;
        if (len != fs.size()) {
            throw new RuntimeException("Mismatch lengths: in ttable there are " + fs.size() + " parameters for e=" + e + ", but in the IA there are " + len);
        }
        fs.copyTo(this._values, from);
    }

    public float get(int e, int f) {
        if (e == 0) {
            return this._nullValues.get(f);
        }
        int min = this._e[e];
        int max = this._e[e + 1] - 1;
        while (min <= max) {
            int mid = (min + max) / 2;
            if (this._ef[mid] > f) {
                max = mid - 1;
                continue;
            }
            if (this._ef[mid] < f) {
                min = mid + 1;
                continue;
            }
            return this._values[mid];
        }
        return 0.0f;
    }

    public void clear() {
        Arrays.fill(this._values, 0.0f);
    }

    public void prune(float threshold) {
        throw new RuntimeException("Not implemented");
    }

    public void normalize() {
        this._nullValues.normalize();
        for (int e = 1; e < this._e.length - 1; ++e) {
            int f;
            int bf = this._e[e];
            int ef = this._e[e + 1];
            float total = 0.0f;
            for (f = bf; f < ef; ++f) {
                total += this._values[f];
            }
            if (total == 0.0f) {
                float u = 1.0f / (float)(ef - bf);
                for (int f2 = bf; f2 < ef; ++f2) {
                    this._values[f2] = u;
                }
                continue;
            }
            f = bf;
            while (f < ef) {
                int n = f++;
                this._values[n] = this._values[n] / total;
            }
        }
    }

    public void readFields(DataInput in) throws IOException {
        int bbLen = in.readInt();
        ByteBuffer bb = ByteBuffer.allocate(bbLen);
        in.readFully(bb.array());
        IntBuffer ib = bb.asIntBuffer();
        this._e = new int[bbLen / 4];
        ib.get(this._e);
        this.eLen = this._e.length;
        if (this._nullValues == null) {
            this._nullValues = new IndexedFloatArray();
        }
        this._nullValues.readFields(in);
        bbLen = in.readInt();
        bb = ByteBuffer.allocate(bbLen);
        in.readFully(bb.array());
        ib = bb.asIntBuffer();
        this._ef = new int[bbLen / 4];
        ib.get(this._ef);
        bb = ByteBuffer.allocate(bbLen);
        in.readFully(bb.array());
        FloatBuffer fb = bb.asFloatBuffer();
        this._values = new float[bbLen / 4];
        fb.get(this._values);
        this.indexLen = this._values.length;
    }

    public void write(DataOutput out) throws IOException {
        int bbLen = this.eLen * 4;
        out.writeInt(bbLen);
        ByteBuffer bb = ByteBuffer.allocate(bbLen);
        IntBuffer ib = bb.asIntBuffer();
        ib.put(this._e, 0, this.eLen);
        out.write(bb.array());
        this._nullValues.write(out);
        bbLen = this.indexLen * 4;
        out.writeInt(bbLen);
        bb = ByteBuffer.allocate(bbLen);
        ib = bb.asIntBuffer();
        ib.put(this._ef, 0, this.indexLen);
        out.write(bb.array());
        bb = ByteBuffer.allocate(bbLen);
        FloatBuffer fb = bb.asFloatBuffer();
        fb.put(this._values, 0, this.indexLen);
        out.write(bb.array());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("NULL: ").append(this._nullValues.toString()).append("\n");
        for (int e = 1; e < this._e.length - 1; ++e) {
            int bfi = this._e[e];
            int efi = this._e[e + 1];
            for (int fi = bfi; fi < efi; ++fi) {
                sb.append("e=").append(e).append(" f=").append(this._ef[fi]).append(" val=").append(this._values[fi]).append("\n");
            }
        }
        return sb.toString();
    }

    public void write() throws IOException {
        this.write((DataOutput)this._fs.create(this._datapath));
    }
}

