/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.hooka.ttables;

import edu.umd.hooka.alignment.IndexedFloatArray;
import edu.umd.hooka.ttables.TTable;
import java.io.DataInput;
import java.io.IOException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class TTable_sliced
extends TTable
implements Cloneable {
    IndexedFloatArray[] _data;
    Path _datapath;
    FileSystem _fs;
    boolean cleared = false;

    public Object clone() {
        TTable_sliced res = new TTable_sliced();
        res._datapath = this._datapath;
        res._fs = this._fs;
        res.cleared = this.cleared;
        res._data = new IndexedFloatArray[this._data.length];
        for (int i = 0; i < this._data.length; ++i) {
            res._data[i] = (IndexedFloatArray)this._data[i].clone();
        }
        return res;
    }

    public TTable_sliced() {
    }

    public TTable_sliced(int e_voc_size) {
        this._data = new IndexedFloatArray[e_voc_size];
    }

    public TTable_sliced(FileSystem fs, Path p) throws IOException {
        this._fs = fs;
        this._datapath = p;
        FSDataInputStream in = this._fs.open(this._datapath.suffix("/metadata.bin"));
        this._data = new IndexedFloatArray[in.readInt()];
        in.close();
    }

    public TTable_sliced(int e_voc_size, FileSystem fs, Path p) {
        this._fs = fs;
        this._datapath = p;
        this._data = new IndexedFloatArray[e_voc_size];
    }

    public int getMaxF() {
        return this._data[0].size() - 1;
    }

    public int getMaxE() {
        return this._data.length - 1;
    }

    private final void checkE(int e) {
        if (this._data[e] == null) {
            try {
                this._data[e] = new IndexedFloatArray();
                FSDataInputStream in = this._fs.open(this._datapath.suffix("/voc_" + e + ".tab"));
                this._data[e].readFields((DataInput)in);
                in.close();
                if (this.cleared) {
                    this._data[e].clear();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                throw new RuntimeException("Caught " + e);
            }
        }
    }

    public void add(int e, int f, float delta) {
        this.checkE(e);
        this._data[e].add(f, delta);
    }

    public void set(int e, int f, float value) {
        this.checkE(e);
        this._data[e].set(f, value);
    }

    public long getCoord(int e, int f) {
        return (long)e << 32 | (long)this._data[e].getAddr(f);
    }

    public void add_addr(long coord, float delta) {
        this._data[(int)(coord >> 32)].add((int)(coord & 0xFFFFFFFFL), delta);
    }

    public void set(int e, IndexedFloatArray fs) {
        if (this._data[e] == null) {
            this._data[e] = (IndexedFloatArray)fs.clone();
        } else {
            this._data[e].copyFrom(fs);
        }
    }

    public float get(int e, int f) {
        this.checkE(e);
        return this._data[e].get(f);
    }

    public void clear() {
        this.cleared = true;
        for (IndexedFloatArray ar : this._data) {
            if (ar == null) continue;
            ar.clear();
        }
    }

    public void prune(float threshold) {
        throw new RuntimeException("Not implemented");
    }

    public void normalize() {
        for (IndexedFloatArray ar : this._data) {
            if (ar == null) continue;
            ar.normalize();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int e = 0; e < this._data.length; ++e) {
            sb.append("e=").append(e).append(' ').append(this._data[e]).append('\n');
        }
        return sb.toString();
    }

    public void write() throws IOException {
        throw new RuntimeException("Not implemented");
    }
}

