/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.rtf.beans.keywords;

import com.google.common.base.Preconditions;
import edu.umn.biomedicus.rtf.beans.keywords.ControlKeyword;
import edu.umn.biomedicus.rtf.reader.KeywordAction;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.bind.JAXB;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
@XmlType
public class ControlKeywordsDescription {
    private List<ControlKeyword> controlKeywords;

    public static ControlKeywordsDescription loadFromFile(String classpath) {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(classpath);
        return (ControlKeywordsDescription)JAXB.unmarshal((InputStream)inputStream, ControlKeywordsDescription.class);
    }

    @XmlElementWrapper(required=true)
    @XmlElement(name="controlKeyword")
    public List<ControlKeyword> getControlKeywords() {
        return this.controlKeywords;
    }

    public void setControlKeywords(List<ControlKeyword> controlKeywords) {
        this.controlKeywords = controlKeywords;
    }

    public Map<String, KeywordAction> getKeywordActionsAsMap() {
        assert (this.controlKeywords != null);
        Preconditions.checkNotNull(this.controlKeywords);
        return this.controlKeywords.stream().collect(Collectors.toMap(ControlKeyword::getKeyword, ControlKeyword::getKeywordAction));
    }
}

