/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.rtf.beans.properties;

import edu.umn.biomedicus.rtf.beans.properties.PropertyGroupDescription;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.bind.JAXB;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
@XmlType
public class PropertiesDescription {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesDescription.class);
    private List<PropertyGroupDescription> propertyGroupDescriptions;

    public static PropertiesDescription loadFromFile(String classpath) {
        LOGGER.debug("Loading properties description from: {}", (Object)classpath);
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(classpath);
        return (PropertiesDescription)JAXB.unmarshal((InputStream)inputStream, PropertiesDescription.class);
    }

    @XmlElementWrapper(name="propertyGroups")
    @XmlElementRef
    public List<PropertyGroupDescription> getPropertyGroupDescriptions() {
        return this.propertyGroupDescriptions;
    }

    public void setPropertyGroupDescriptions(List<PropertyGroupDescription> propertyGroupDescriptions) {
        this.propertyGroupDescriptions = propertyGroupDescriptions;
    }

    public Map<String, Map<String, Integer>> createProperties() {
        LOGGER.debug("Creating state properties from description.");
        return this.propertyGroupDescriptions.stream().collect(Collectors.toMap(PropertyGroupDescription::getName, PropertyGroupDescription::createPropertyGroup));
    }
}

