/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.rtf.reader;

import edu.umn.biomedicus.rtf.exc.EndOfFileException;
import edu.umn.biomedicus.rtf.exc.InvalidKeywordException;
import edu.umn.biomedicus.rtf.exc.InvalidParameterException;
import edu.umn.biomedicus.rtf.exc.RtfReaderException;
import edu.umn.biomedicus.rtf.reader.KeywordAction;
import edu.umn.biomedicus.rtf.reader.RtfSource;
import edu.umn.biomedicus.rtf.reader.UnknownKeywordAction;
import java.util.Map;

public class RtfKeywordParser {
    public static final int KEYWORD_MAX = 32;
    public static final int PARAMETER_MAX = 10;
    private final Map<String, KeywordAction> keywordActionMap;

    public RtfKeywordParser(Map<String, KeywordAction> keywordActionMap) {
        this.keywordActionMap = keywordActionMap;
    }

    public KeywordAction parse(int index, RtfSource rtfSource) throws RtfReaderException {
        KeywordAction keywordAction;
        String controlWord;
        int ch = rtfSource.readCharacter();
        Integer parameter = null;
        if (ch == -1) {
            throw new EndOfFileException();
        }
        if (!Character.isAlphabetic(ch)) {
            controlWord = "" + (char)ch;
            ch = rtfSource.readCharacter();
        } else {
            StringBuilder controlWordBuilder = new StringBuilder(32);
            do {
                controlWordBuilder.append((char)ch);
                ch = rtfSource.readCharacter();
            } while (controlWordBuilder.length() <= 33 && Character.isAlphabetic(ch));
            controlWord = controlWordBuilder.toString();
            if (controlWord.length() > 32) {
                throw new InvalidKeywordException("Keyword control word too long: " + controlWord);
            }
            boolean parameterIsNegative = false;
            if (ch == 45) {
                parameterIsNegative = true;
                ch = rtfSource.readCharacter();
            }
            if (Character.isDigit(ch)) {
                StringBuilder parameterBuilder = new StringBuilder(10);
                do {
                    parameterBuilder.append((char)ch);
                    ch = rtfSource.readCharacter();
                } while (parameterBuilder.length() <= 11 && Character.isDigit(ch));
                String parameterString = parameterBuilder.toString();
                if (parameterString.length() > 10) {
                    throw new InvalidParameterException("Keyword parameter too long: " + parameterString);
                }
                try {
                    parameter = (parameterIsNegative ? -1 : 1) * Integer.parseUnsignedInt(parameterString);
                }
                catch (NumberFormatException e) {
                    throw new InvalidParameterException("Unable to parse parameter into integer: " + parameterString);
                }
            }
        }
        if (ch != 32) {
            rtfSource.unreadChar();
        }
        keywordAction = (keywordAction = this.keywordActionMap.get(controlWord)) != null ? keywordAction.copy() : new UnknownKeywordAction();
        keywordAction.setControlWord(controlWord);
        keywordAction.setParameter(parameter);
        keywordAction.setBegin(index);
        keywordAction.setEnd(rtfSource.getIndex());
        return keywordAction;
    }
}

