/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.rtf.reader;

import edu.umn.biomedicus.rtf.exc.RtfReaderException;
import edu.umn.biomedicus.rtf.reader.KeywordAction;
import edu.umn.biomedicus.rtf.reader.RtfKeywordParser;
import edu.umn.biomedicus.rtf.reader.RtfSource;
import edu.umn.biomedicus.rtf.reader.State;
import edu.umn.nlpengine.Span;
import edu.umn.nlpengine.TextRange;
import java.util.ArrayDeque;
import java.util.Deque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RtfParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(RtfParser.class);
    private final RtfKeywordParser rtfKeywordParser;
    private final RtfSource rtfSource;
    private final Deque<State> stateStack;
    private State currentState;

    public RtfParser(RtfKeywordParser rtfKeywordParser, RtfSource rtfSource, State initialState) {
        this.rtfKeywordParser = rtfKeywordParser;
        this.rtfSource = rtfSource;
        this.currentState = initialState;
        this.stateStack = new ArrayDeque<State>();
    }

    public void parseFile() throws RtfReaderException {
        block6: while (true) {
            int index = this.rtfSource.getIndex();
            int ch = this.rtfSource.readCharacter();
            if (ch == -1) break;
            switch (ch) {
                case 123: {
                    this.stateStack.addFirst(this.currentState);
                    this.currentState = this.currentState.copy();
                    continue block6;
                }
                case 125: {
                    if (this.stateStack.size() == 0) {
                        throw new RtfReaderException("Extra closing brace.");
                    }
                    this.currentState = this.stateStack.removeFirst();
                    continue block6;
                }
                case 92: {
                    KeywordAction keywordAction = this.rtfKeywordParser.parse(index, this.rtfSource);
                    this.currentState.handleKeyword(keywordAction);
                    continue block6;
                }
                case 0: {
                    continue block6;
                }
            }
            this.currentState.writeCharacter(ch, (TextRange)Span.create((int)index, (int)this.rtfSource.getIndex()));
        }
    }

    public boolean finish() {
        this.currentState.finishState();
        return this.stateStack.size() == 0;
    }
}

