/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.rtf.reader;

import edu.umn.biomedicus.rtf.exc.RtfReaderException;
import edu.umn.biomedicus.rtf.reader.IndexListener;
import edu.umn.biomedicus.rtf.reader.InputType;
import edu.umn.biomedicus.rtf.reader.KeywordAction;
import edu.umn.biomedicus.rtf.reader.OutputDestination;
import edu.umn.biomedicus.rtf.reader.OutputDestinationFactory;
import edu.umn.nlpengine.Span;
import edu.umn.nlpengine.TextRange;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class State {
    private static final Logger LOGGER = LoggerFactory.getLogger(State.class);
    private final Map<String, OutputDestination> outputDestinationMap;
    private final OutputDestinationFactory outputDestinationFactory;
    private final Map<String, Map<String, Integer>> properties;
    private final IndexListener indexListener;
    @Nullable
    private OutputDestination outputDestination;
    private InputType inputType;
    private int binaryCharactersToRead;
    private boolean skipDestinationIfUnknown;
    private StringBuilder hexStringBuilder;
    private boolean skippingDestination;
    private int ignoreNextChars;
    private Charset charset;
    private int hexStart;

    public State(Map<String, OutputDestination> outputDestinationMap, OutputDestinationFactory outputDestinationFactory, Map<String, Map<String, Integer>> properties, IndexListener indexListener) {
        this.outputDestinationMap = outputDestinationMap;
        this.outputDestinationFactory = outputDestinationFactory;
        this.properties = properties;
        this.indexListener = indexListener;
        this.inputType = InputType.NORMAL;
        this.binaryCharactersToRead = 0;
        this.skipDestinationIfUnknown = false;
        this.skippingDestination = false;
        this.charset = Charset.forName("Windows-1252");
    }

    public static State createState(OutputDestinationFactory outputDestinationFactory, Map<String, Map<String, Integer>> properties, IndexListener indexListener) throws RtfReaderException {
        HashMap<String, OutputDestination> outputDestinationMap = new HashMap<String, OutputDestination>();
        outputDestinationMap.put("Rtf", outputDestinationFactory.create("Rtf"));
        return new State(outputDestinationMap, outputDestinationFactory, properties, indexListener);
    }

    public State copy() {
        Map<String, Map<String, Integer>> propertiesCopy = this.properties.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Map)entry.getValue()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))));
        State stateCopy = new State(this.outputDestinationMap, this.outputDestinationFactory, propertiesCopy, this.indexListener);
        stateCopy.outputDestination = this.outputDestination;
        stateCopy.skippingDestination = this.skippingDestination;
        stateCopy.charset = this.charset;
        return stateCopy;
    }

    public void setToHexInputType(int index) {
        this.inputType = InputType.HEX;
        this.hexStringBuilder = new StringBuilder(2);
        this.hexStart = index;
    }

    public void setToBinaryInputType(int binaryCharactersToRead) {
        this.inputType = InputType.BINARY;
        this.binaryCharactersToRead = binaryCharactersToRead;
    }

    public void markSkipDestinationIfUnknown() {
        this.skipDestinationIfUnknown = true;
    }

    public void writeCharacter(int code, TextRange originalDocumentTextLocation) throws RtfReaderException {
        if (this.skippingDestination) {
            return;
        }
        switch (this.inputType) {
            case BINARY: {
                if (--this.binaryCharactersToRead == 0) {
                    this.inputType = InputType.NORMAL;
                }
                LOGGER.debug("Not writing a binary byte");
                break;
            }
            case NORMAL: {
                this.directWriteCharacter((char)code, originalDocumentTextLocation);
                break;
            }
            case HEX: {
                if (!(code >= 48 && code <= 57 || code >= 97 && code <= 102 || code >= 65 && code <= 70)) {
                    throw new RtfReaderException("Invalid hex code character: " + (char)code);
                }
                this.hexStringBuilder.append((char)code);
                if (this.hexStringBuilder.length() != 2) break;
                String hexString = this.hexStringBuilder.toString();
                Byte charByte = (byte)(Integer.parseInt(hexString, 16) & 0xFF);
                code = this.charset.decode(ByteBuffer.wrap(new byte[]{charByte})).get(0);
                this.directWriteCharacter((char)code, (TextRange)Span.create((int)this.hexStart, (int)originalDocumentTextLocation.getEndIndex()));
                this.inputType = InputType.NORMAL;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown input type.");
            }
        }
    }

    public void directWriteCharacter(char ch, TextRange originalDocumentTextLocation) {
        if (this.ignoreNextChars > 0) {
            --this.ignoreNextChars;
            return;
        }
        if (this.outputDestination != null) {
            int destinationIndex = this.outputDestination.writeChar(ch, this);
            this.indexListener.wroteToDestination(this.outputDestination.getName(), destinationIndex, originalDocumentTextLocation);
        }
    }

    public void changeDestination(String destinationName) throws RtfReaderException {
        if ("SkipDestination".equals(destinationName)) {
            this.outputDestination = null;
            this.skippingDestination = true;
        }
        if (!this.skippingDestination) {
            if (!this.outputDestinationMap.containsKey(destinationName)) {
                this.outputDestinationMap.put(destinationName, this.outputDestinationFactory.create(destinationName));
            }
            this.outputDestination = this.outputDestinationMap.get(destinationName);
            if (this.outputDestination == null) {
                this.skippingDestination = true;
                this.skipDestinationIfUnknown = false;
            }
        }
    }

    public void handleKeyword(KeywordAction keywordAction) throws RtfReaderException {
        if (!this.skippingDestination) {
            if (this.skipDestinationIfUnknown && !keywordAction.isKnown()) {
                this.outputDestination = null;
                this.skippingDestination = true;
                this.skipDestinationIfUnknown = false;
                return;
            }
            this.skipDestinationIfUnknown = false;
            if (this.outputDestination != null) {
                this.outputDestination.controlWordEncountered(keywordAction);
            }
            keywordAction.executeKeyword(this);
        }
    }

    public void setPropertyValue(String group, String property, int value) {
        this.properties.get(group).put(property, value);
    }

    public void resetPropertyGroup(String group) {
        this.properties.get(group).replaceAll((k, v) -> 0);
    }

    public int getPropertyValue(String group, String property) {
        Map<String, Integer> propertyGroup = this.properties.get(group);
        if (propertyGroup == null) {
            throw new IllegalArgumentException("Group not found");
        }
        Integer propertyValue = propertyGroup.get(property);
        if (propertyValue == null) {
            throw new IllegalArgumentException("Property not found");
        }
        return propertyValue;
    }

    public void finishState() {
        this.outputDestinationMap.values().forEach(OutputDestination::finishDestination);
    }

    public void setIgnoreNextChars(int ignoreNextChars) {
        this.ignoreNextChars = ignoreNextChars;
    }
}

