/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.measures;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;

public class UnitRecognizer {
    private final Map<String, String> unitOfMeasureMap;
    private int start = -1;
    private int end = -1;
    private StringBuilder codeBuilder = new StringBuilder();

    public UnitRecognizer(Map<String, String> unitOfMeasureMap) {
        this.unitOfMeasureMap = unitOfMeasureMap;
    }

    public boolean inProgress() {
        return this.start != -1;
    }

    public Optional<Result> advance(CharSequence token, int begin, int end) {
        String lowercased = token.toString().toLowerCase();
        return this.advanceLowercased(lowercased, begin, end);
    }

    public Optional<Result> advanceLowercased(String token, int begin, int end) {
        if (this.isUnitOfMeasureWord(token)) {
            this.start = begin;
            this.end = end;
        } else if (!token.equals("/") && !token.equals("per") && begin != -1) {
            Result result = new Result();
            result.begin = this.start;
            result.end = this.end;
            result.code = this.codeBuilder.toString();
            this.reset();
            this.advanceLowercased(token, begin, end);
            return Optional.of(result);
        }
        return Optional.empty();
    }

    private void reset() {
        this.start = -1;
        this.end = -1;
        this.codeBuilder = new StringBuilder();
    }

    public Optional<Result> finish() {
        if (this.start != -1) {
            Result result = new Result();
            result.begin = this.start;
            result.end = this.end;
            result.code = this.codeBuilder.toString();
            this.reset();
            return Optional.of(result);
        }
        return Optional.empty();
    }

    public boolean isUnitOfMeasureWord(String string) {
        String lowercase = string.toLowerCase();
        return this.unitOfMeasureMap.containsKey(lowercase) || string.charAt(string.length() - 1) == '.' && this.unitOfMeasureMap.containsKey(lowercase.substring(0, string.length() - 1));
    }

    public boolean isUnitOfMeasureWordLowercased(String lowercase) {
        return this.unitOfMeasureMap.containsKey(lowercase) || lowercase.charAt(lowercase.length() - 1) == '.' && this.unitOfMeasureMap.containsKey(lowercase.substring(0, lowercase.length() - 1));
    }

    public static Factory createFactory(Path unitsOfMeasureFile) throws IOException {
        try (BufferedReader unitsReader = Files.newBufferedReader(unitsOfMeasureFile, StandardCharsets.UTF_8);){
            Factory factory = UnitRecognizer.createFactory(unitsReader);
            return factory;
        }
    }

    public static Factory createFactory() throws IOException {
        ClassLoader classLoader = UnitRecognizer.class.getClassLoader();
        try (BufferedReader unitsReader = new BufferedReader(new InputStreamReader(classLoader.getResourceAsStream("edu/umn/biomedicus/measures/unitsOfMeasure.txt")));){
            Factory factory = UnitRecognizer.createFactory(unitsReader);
            return factory;
        }
    }

    private static Factory createFactory(BufferedReader unitsReader) throws IOException {
        String line;
        HashMap<String, String> unitsOfMeasureMap = new HashMap<String, String>();
        Pattern split = Pattern.compile(":");
        while ((line = unitsReader.readLine()) != null) {
            String[] splits;
            if (line.isEmpty() || (splits = split.split(line)).length != 2) continue;
            unitsOfMeasureMap.put(splits[0], splits[1]);
        }
        return new Factory(unitsOfMeasureMap);
    }

    public static final class Result {
        private int begin;
        private int end;
        private String code;

        Result() {
        }

        public int getBegin() {
            return this.begin;
        }

        public int getEnd() {
            return this.end;
        }

        public String getCode() {
            return this.code;
        }
    }

    public static class Factory {
        private final Map<String, String> unitOfMeasureMap;

        Factory(Map<String, String> unitOfMeasureMap) {
            this.unitOfMeasureMap = unitOfMeasureMap;
        }

        public UnitRecognizer create() {
            return new UnitRecognizer(this.unitOfMeasureMap);
        }
    }
}

