/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.numbers;

import edu.umn.biomedicus.numbers.NumberResult;
import edu.umn.biomedicus.numbers.Token;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;

public abstract class AbstractNumberDetector {
    @Nonnull
    public abstract List<NumberResult> tryToken(@Nonnull String var1, int var2, int var3);

    @Nonnull
    public abstract List<NumberResult> finish();

    public List<NumberResult> checkTokens(Iterable<Token> tokens) {
        ArrayList<NumberResult> results = new ArrayList<NumberResult>();
        for (Token token : tokens) {
            results.addAll(this.tryToken(token.getText(), token.getBegin(), token.getEnd()));
        }
        results.addAll(this.finish());
        return results;
    }

    public Iterable<NumberResult> findNumbers(final Iterable<Token> tokens) {
        return () -> new Iterator<NumberResult>(){
            NumberResult next = null;
            Iterator current = null;
            Iterator tokenIt = tokens.iterator();
            {
                this.advance();
            }

            void advance() {
                block1: {
                    Token nextToken;
                    List<NumberResult> results;
                    this.next = this.current != null && this.current.hasNext() ? (NumberResult)this.current.next() : null;
                    do {
                        if (this.tokenIt.hasNext()) continue;
                        this.current = AbstractNumberDetector.this.finish().iterator();
                        break block1;
                    } while ((results = AbstractNumberDetector.this.tryToken((nextToken = (Token)this.tokenIt.next()).getText(), nextToken.getBegin(), nextToken.getEnd())).isEmpty());
                    this.current = results.iterator();
                    this.next = (NumberResult)this.current.next();
                }
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public NumberResult next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                NumberResult next = this.next;
                this.advance();
                return next;
            }
        };
    }
}

