/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.numbers;

import edu.umn.biomedicus.numbers.AbstractNumberDetector;
import edu.umn.biomedicus.numbers.EnglishNumeralsAcceptor;
import edu.umn.biomedicus.numbers.FractionNumberDetector;
import edu.umn.biomedicus.numbers.NumberResult;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class CombinedNumberDetector
extends AbstractNumberDetector {
    private final FractionNumberDetector fractionNumberDetector;
    private final EnglishNumeralsAcceptor englishAcceptor;

    CombinedNumberDetector(FractionNumberDetector fractionNumberDetector, EnglishNumeralsAcceptor englishAcceptor) {
        this.fractionNumberDetector = fractionNumberDetector;
        this.englishAcceptor = englishAcceptor;
    }

    @Override
    @Nonnull
    public List<NumberResult> tryToken(String token, int tokenBegin, int tokenEnd) {
        List<NumberResult> results = this.fractionNumberDetector.tryToken(token, tokenBegin, tokenEnd);
        if (!results.isEmpty()) {
            this.englishAcceptor.reset();
            return results;
        }
        results = this.englishAcceptor.tryToken(token, tokenBegin, tokenEnd);
        if (!results.isEmpty()) {
            this.fractionNumberDetector.reset();
            return results;
        }
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public List<NumberResult> finish() {
        List<NumberResult> results = this.fractionNumberDetector.finish();
        if (!results.isEmpty()) {
            this.englishAcceptor.reset();
            return results;
        }
        results = this.englishAcceptor.finish();
        if (!results.isEmpty()) {
            return results;
        }
        return Collections.emptyList();
    }
}

