/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.numbers;

import edu.umn.biomedicus.numbers.NumberResult;
import edu.umn.biomedicus.numbers.NumberType;
import java.math.BigDecimal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DecimalNumberAcceptor {
    @Nullable
    public NumberResult tryToken(@Nonnull CharSequence token, int tokenBegin, int tokenEnd) {
        int i;
        StringBuilder digits;
        boolean isOrdinal = false;
        if (token.length() == 0) {
            return null;
        }
        char ch = token.charAt(0);
        boolean negative = false;
        if (ch == '+') {
            digits = new StringBuilder();
        } else if (ch == '-') {
            digits = new StringBuilder();
            negative = true;
        } else if (Character.isDigit(ch)) {
            digits = new StringBuilder();
            digits.append(ch);
        } else {
            return null;
        }
        int period = -1;
        for (int i2 = 1; i2 < token.length(); ++i2) {
            ch = token.charAt(i2);
            if (ch == ',') continue;
            if (ch == '.') {
                period = digits.length();
                continue;
            }
            if (Character.isDigit(ch)) {
                digits.append(ch);
                continue;
            }
            if (i2 + 1 >= token.length() || !(ch == 't' && token.charAt(i2 + 1) == 'h' || ch == 's' && token.charAt(i2 + 1) == 't' || ch == 'n' && token.charAt(i2 + 1) == 'd') && (ch != 'r' || token.charAt(i2 + 1) != 'd')) continue;
            isOrdinal = true;
            break;
        }
        if (digits.length() == 0) {
            return null;
        }
        BigDecimal value = BigDecimal.ZERO;
        BigDecimal ten = BigDecimal.valueOf(10L);
        if (period != -1) {
            for (i = 0; i < period; ++i) {
                value = value.multiply(ten).add(new BigDecimal("" + digits.charAt(i)));
            }
            for (i = period; i < digits.length(); ++i) {
                value = value.add(new BigDecimal("" + digits.charAt(i)).divide(ten.pow(i - period + 1)));
            }
        } else {
            for (i = 0; i < digits.length(); ++i) {
                value = value.multiply(ten).add(new BigDecimal("" + digits.charAt(i)));
            }
        }
        if (negative) {
            value = value.negate();
        }
        NumberType numberType = NumberType.DECIMAL;
        if (isOrdinal) {
            numberType = NumberType.ORDINAL;
        }
        return new NumberResult(tokenBegin, tokenEnd, value, BigDecimal.ONE, numberType);
    }
}

