/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.numbers;

import edu.umn.biomedicus.numbers.AbstractNumberDetector;
import edu.umn.biomedicus.numbers.BasicNumberType;
import edu.umn.biomedicus.numbers.NumberDefinition;
import edu.umn.biomedicus.numbers.NumberModel;
import edu.umn.biomedicus.numbers.NumberResult;
import edu.umn.biomedicus.numbers.NumberType;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EnglishNumeralsAcceptor
extends AbstractNumberDetector {
    private final NonFractionAcceptor nonFractionAcceptor;
    @Nullable
    private BigDecimal numerator;
    @Nullable
    private BigDecimal denominator;
    private int begin;
    private int end;
    @Nullable
    private NumberType numberType;
    private int andHalf = 0;

    EnglishNumeralsAcceptor(NonFractionAcceptor nonFractionAcceptor) {
        this.nonFractionAcceptor = nonFractionAcceptor;
    }

    public static EnglishNumeralsAcceptor create(NumberModel numberModel) {
        return new EnglishNumeralsAcceptor(new NonFractionAcceptor(numberModel, new BasicNumberAcceptor(numberModel)));
    }

    public void reset() {
        this.numerator = null;
        this.denominator = null;
        this.nonFractionAcceptor.reset();
        this.numberType = null;
        this.andHalf = 0;
    }

    @Override
    @Nonnull
    public List<NumberResult> tryToken(@Nonnull String token, int tokenBegin, int tokenEnd) {
        NumberResult previous = null;
        for (int i = 0; i < 2; ++i) {
            if (this.numerator == null) {
                if (this.nonFractionAcceptor.tryToken(token, tokenBegin, tokenEnd)) {
                    this.numerator = this.nonFractionAcceptor.value;
                    this.begin = this.nonFractionAcceptor.begin;
                    this.end = this.nonFractionAcceptor.end;
                    this.nonFractionAcceptor.reset();
                    this.nonFractionAcceptor.setDenominator();
                    if (this.nonFractionAcceptor.isOrdinal) {
                        this.numberType = NumberType.ORDINAL;
                        NumberResult current = new NumberResult(this.begin, this.end, this.numerator, BigDecimal.ONE, this.numberType);
                        this.reset();
                        return previous != null ? Arrays.asList(previous, current) : Collections.singletonList(current);
                    }
                    this.numberType = NumberType.CARDINAL;
                    if (this.nonFractionAcceptor.consumedLastToken) {
                        return previous != null ? Collections.singletonList(previous) : Collections.emptyList();
                    }
                } else {
                    return previous != null ? Collections.singletonList(previous) : Collections.emptyList();
                }
            }
            if (token.equals("-")) {
                return previous != null ? Collections.singletonList(previous) : Collections.emptyList();
            }
            if (this.andHalf == 1 && token.equalsIgnoreCase("a")) {
                this.andHalf = 2;
            } else {
                if (this.andHalf == 2 && token.equalsIgnoreCase("half")) {
                    this.denominator = BigDecimal.valueOf(2L);
                    this.numerator = this.numerator.multiply(this.denominator).add(BigDecimal.ONE);
                    this.numberType = NumberType.FRACTION;
                    this.end = tokenEnd;
                    NumberResult halfResult = this.stateToResult();
                    this.reset();
                    return Collections.singletonList(halfResult);
                }
                if (token.equalsIgnoreCase("and")) {
                    this.andHalf = 1;
                } else {
                    if (this.nonFractionAcceptor.tryToken(token, tokenBegin, tokenEnd)) {
                        this.denominator = this.nonFractionAcceptor.value;
                        this.end = this.nonFractionAcceptor.end;
                        this.numberType = NumberType.FRACTION;
                        previous = this.stateToResult();
                        if (!this.nonFractionAcceptor.consumedLastToken) continue;
                        this.reset();
                        return Collections.singletonList(previous);
                    }
                    if (!this.nonFractionAcceptor.inProgress()) {
                        this.denominator = BigDecimal.ONE;
                        if (previous != null) {
                            throw new IllegalStateException("Losing a value before returning it.");
                        }
                        previous = this.stateToResult();
                        this.reset();
                    }
                    if (!this.nonFractionAcceptor.consumedLastToken) continue;
                }
            }
            return previous != null ? Collections.singletonList(previous) : Collections.emptyList();
        }
        return previous != null ? Collections.singletonList(previous) : Collections.emptyList();
    }

    @Override
    @Nonnull
    public List<NumberResult> finish() {
        if (this.numerator == null) {
            if (this.nonFractionAcceptor.finish()) {
                this.numerator = this.nonFractionAcceptor.value;
                this.begin = this.nonFractionAcceptor.begin;
                this.end = this.nonFractionAcceptor.end;
                this.numberType = this.nonFractionAcceptor.isOrdinal ? NumberType.ORDINAL : NumberType.CARDINAL;
                return Collections.singletonList(this.stateToResult());
            }
        } else if (this.nonFractionAcceptor.finish()) {
            this.denominator = this.nonFractionAcceptor.value;
            this.end = this.nonFractionAcceptor.end;
            this.numberType = NumberType.FRACTION;
            return Collections.singletonList(this.stateToResult());
        }
        return Collections.emptyList();
    }

    private NumberResult stateToResult() {
        return new NumberResult(this.begin, this.end, this.numerator, this.denominator, this.numberType);
    }

    static class NonFractionAcceptor {
        private final NumberModel numberModel;
        private final BasicNumberAcceptor basicNumberAcceptor;
        private State state;
        @Nullable
        BigDecimal value;
        private int valueBuilder = 0;
        int begin = -1;
        int end = -1;
        private boolean canBeDenominator;
        boolean isDenominator;
        boolean isOrdinal;
        boolean consumedLastToken;

        NonFractionAcceptor(NumberModel numberModel, BasicNumberAcceptor basicNumberAcceptor) {
            this.basicNumberAcceptor = basicNumberAcceptor;
            this.numberModel = numberModel;
            this.reset();
        }

        private void reset() {
            this.state = State.NONE;
            this.value = null;
            this.valueBuilder = -1;
            this.begin = -1;
            this.end = -1;
            this.consumedLastToken = false;
            this.canBeDenominator = false;
            this.isDenominator = false;
            this.isOrdinal = false;
            this.basicNumberAcceptor.reset();
        }

        boolean tryToken(String token, int tokenBegin, int tokenEnd) {
            NumberDefinition numberDefinition = this.numberModel.getNumberDefinition(token);
            switch (this.state) {
                case NONE: {
                    if (this.value != null && "and".equalsIgnoreCase(token)) {
                        return false;
                    }
                    boolean basicTry = this.basicNumberAcceptor.tryToken(token, tokenBegin, tokenEnd);
                    this.consumedLastToken = this.basicNumberAcceptor.consumedLastToken;
                    if (basicTry) {
                        this.state = State.HAS_BASIC;
                        if (this.value == null) {
                            this.begin = this.basicNumberAcceptor.begin;
                        }
                        this.end = this.basicNumberAcceptor.end;
                        this.valueBuilder = this.basicNumberAcceptor.value;
                        if (this.basicNumberAcceptor.isDenominator || this.basicNumberAcceptor.isOrdinal || !this.basicNumberAcceptor.consumedLastToken) {
                            this.value = BigDecimal.valueOf(this.valueBuilder);
                            return true;
                        }
                    } else if (this.value != null) break;
                    return false;
                }
                case HAS_BASIC: {
                    if ("hundred".equalsIgnoreCase(token)) {
                        this.state = State.RANK_01;
                        this.valueBuilder *= 100;
                        this.end = tokenEnd;
                        this.basicNumberAcceptor.reset();
                        return false;
                    }
                    if ("hundredth".equalsIgnoreCase(token)) {
                        if (this.canBeDenominator) {
                            this.isDenominator = true;
                        } else {
                            this.isOrdinal = true;
                        }
                        this.valueBuilder *= 100;
                        this.end = tokenEnd;
                        this.basicNumberAcceptor.reset();
                        this.value = BigDecimal.valueOf(this.valueBuilder);
                        this.consumedLastToken = true;
                        return true;
                    }
                    if (!"hundredths".equalsIgnoreCase(token)) break;
                    this.isDenominator = true;
                    this.valueBuilder *= 100;
                    this.end = tokenEnd;
                    this.basicNumberAcceptor.reset();
                    this.value = BigDecimal.valueOf(this.valueBuilder);
                    this.consumedLastToken = true;
                    return true;
                }
                case RANK_01: {
                    if ("and".equalsIgnoreCase(token)) {
                        return false;
                    }
                    if (this.basicNumberAcceptor.state != BasicNumberAcceptor.State.NONE) {
                        if (this.basicNumberAcceptor.tryToken(token, tokenBegin, tokenEnd)) {
                            this.valueBuilder += this.basicNumberAcceptor.value;
                            this.end = this.basicNumberAcceptor.end;
                            this.state = State.PAST_FIRST_PART;
                        }
                    } else {
                        this.basicNumberAcceptor.tryToken(token, tokenBegin, tokenEnd);
                        if (this.basicNumberAcceptor.state == BasicNumberAcceptor.State.NONE) break;
                    }
                    return false;
                }
            }
            if (numberDefinition != null && BasicNumberType.MAGNITUDE == numberDefinition.getBasicNumberType()) {
                this.value = this.value != null ? this.value.add(BigDecimal.valueOf(1000L).pow(numberDefinition.getValue()).multiply(BigDecimal.valueOf(this.valueBuilder))) : BigDecimal.valueOf(1000L).pow(numberDefinition.getValue()).multiply(BigDecimal.valueOf(this.valueBuilder));
                this.valueBuilder = 0;
                this.end = tokenEnd;
                this.state = State.NONE;
                return false;
            }
            if (this.canBeDenominator && (numberDefinition = this.numberModel.getDenominator(token)) != null && numberDefinition.getBasicNumberType() == BasicNumberType.MAGNITUDE) {
                this.value = this.value != null ? this.value.add(BigDecimal.valueOf(1000L).pow(numberDefinition.getValue()).multiply(BigDecimal.valueOf(this.valueBuilder))) : BigDecimal.valueOf(1000L).pow(numberDefinition.getValue()).multiply(BigDecimal.valueOf(this.valueBuilder));
                this.end = tokenEnd;
                this.consumedLastToken = true;
                return true;
            }
            this.value = this.value == null ? BigDecimal.valueOf(this.valueBuilder) : this.value.add(BigDecimal.valueOf(this.valueBuilder));
            this.consumedLastToken = false;
            return true;
        }

        boolean finish() {
            switch (this.state) {
                case NONE: {
                    if (!this.basicNumberAcceptor.finish()) break;
                    this.state = State.HAS_BASIC;
                    if (this.value == null) {
                        this.begin = this.basicNumberAcceptor.begin;
                    }
                    this.end = this.basicNumberAcceptor.end;
                    this.valueBuilder = this.basicNumberAcceptor.value;
                    break;
                }
                case HAS_BASIC: 
                case RANK_01: {
                    if (this.basicNumberAcceptor.state == BasicNumberAcceptor.State.NONE || !this.basicNumberAcceptor.finish()) break;
                    this.valueBuilder += this.basicNumberAcceptor.value;
                    this.end = this.basicNumberAcceptor.end;
                    this.state = State.PAST_FIRST_PART;
                }
            }
            if (this.value == null) {
                if (this.state == State.NONE) {
                    return false;
                }
                this.value = BigDecimal.valueOf(this.valueBuilder);
            } else {
                this.value = this.value.add(BigDecimal.valueOf(this.valueBuilder));
            }
            return true;
        }

        boolean inProgress() {
            return this.state != State.NONE || this.basicNumberAcceptor.state != BasicNumberAcceptor.State.NONE;
        }

        void setDenominator() {
            this.canBeDenominator = true;
            this.basicNumberAcceptor.canBeDenominator = true;
        }

        static enum State {
            NONE,
            HAS_BASIC,
            RANK_01,
            PAST_FIRST_PART,
            POST_MAGNITUDE;

        }
    }

    static class BasicNumberAcceptor {
        final NumberModel numberModel;
        int value;
        int begin;
        int end;
        State state;
        Type type;
        boolean consumedLastToken;
        boolean canBeDenominator;
        boolean isDenominator;
        boolean isOrdinal;

        BasicNumberAcceptor(NumberModel numberModel) {
            this.numberModel = numberModel;
            this.reset();
        }

        void reset() {
            this.value = -1;
            this.begin = -1;
            this.end = -1;
            this.state = State.NONE;
            this.type = null;
            this.consumedLastToken = false;
            this.canBeDenominator = false;
            this.isDenominator = false;
            this.isOrdinal = false;
        }

        boolean tryToken(String token, int tokenStart, int tokenEnd) {
            NumberDefinition numberDefinition = null;
            if (this.canBeDenominator && (numberDefinition = this.numberModel.getDenominator(token)) != null) {
                this.isDenominator = true;
            }
            if (numberDefinition == null) {
                numberDefinition = this.numberModel.getNumberDefinition(token);
            }
            if (numberDefinition == null && (numberDefinition = this.numberModel.getOrdinal(token)) != null) {
                this.isOrdinal = true;
            }
            switch (this.state) {
                case NONE: {
                    if (numberDefinition == null) break;
                    switch (numberDefinition.getBasicNumberType()) {
                        case TEEN: {
                            this.value = numberDefinition.getValue();
                            this.begin = tokenStart;
                            this.end = tokenEnd;
                            this.type = Type.TEEN;
                            this.consumedLastToken = true;
                            return true;
                        }
                        case UNIT: {
                            this.value = numberDefinition.getValue();
                            this.begin = tokenStart;
                            this.end = tokenEnd;
                            this.type = Type.UNIT;
                            this.consumedLastToken = true;
                            return true;
                        }
                        case DECADE: {
                            this.state = State.DECADE;
                            this.value = numberDefinition.getValue();
                            this.begin = tokenStart;
                            this.end = tokenEnd;
                            this.type = Type.DECADE;
                            this.consumedLastToken = true;
                            if (!this.isDenominator && !this.isOrdinal) break;
                            return true;
                        }
                    }
                    break;
                }
                case DECADE: {
                    if ("-".equals(token)) {
                        this.state = State.DECADE_HYPHEN;
                        return false;
                    }
                }
                case DECADE_HYPHEN: {
                    if (numberDefinition != null && numberDefinition.getBasicNumberType() == BasicNumberType.UNIT) {
                        this.value += numberDefinition.getValue();
                        this.end = tokenEnd;
                        this.type = Type.DECADE_UNIT;
                        this.consumedLastToken = true;
                        return true;
                    }
                    this.consumedLastToken = false;
                    return true;
                }
            }
            return false;
        }

        boolean finish() {
            switch (this.state) {
                case DECADE: 
                case DECADE_HYPHEN: {
                    return true;
                }
            }
            return false;
        }

        private static enum Type {
            UNIT,
            TEEN,
            DECADE,
            DECADE_UNIT;

        }

        private static enum State {
            DECADE,
            DECADE_HYPHEN,
            NONE;

        }
    }
}

