/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.numbers;

import edu.umn.biomedicus.numbers.AbstractNumberDetector;
import edu.umn.biomedicus.numbers.DecimalNumberAcceptor;
import edu.umn.biomedicus.numbers.NumberResult;
import edu.umn.biomedicus.numbers.NumberType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FractionNumberDetector
extends AbstractNumberDetector {
    private final DecimalNumberAcceptor decimalNumberAcceptor;
    @Nullable
    private NumberResult numerator = null;
    @Nullable
    private NumberResult denominator = null;
    boolean sawSlash = false;

    FractionNumberDetector(DecimalNumberAcceptor decimalNumberAcceptor) {
        this.decimalNumberAcceptor = decimalNumberAcceptor;
    }

    public FractionNumberDetector() {
        this(new DecimalNumberAcceptor());
    }

    public void reset() {
        this.numerator = null;
        this.denominator = null;
        this.sawSlash = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nonnull
    public List<NumberResult> tryToken(String token, int begin, int end) {
        NumberResult next = this.decimalNumberAcceptor.tryToken(token, begin, end);
        if (this.numerator == null) {
            this.numerator = next;
            if (this.numerator == null || !this.numerator.getNumberType().equals((Object)NumberType.ORDINAL)) return Collections.emptyList();
            return this.swapAndReturnNumerator(null);
        }
        if (this.denominator == null) {
            if (this.sawSlash) {
                this.denominator = next;
                if (this.denominator != null) return Collections.emptyList();
                List<NumberResult> result = this.swapAndReturnNumerator(null);
                this.sawSlash = false;
                return result;
            }
            if (token.length() != 1 || token.charAt(0) != '/') return this.swapAndReturnNumerator(next);
            this.sawSlash = true;
            return Collections.emptyList();
        } else {
            List<NumberResult> result = token.length() == 1 && token.charAt(0) == '/' ? Arrays.asList(this.numerator, this.denominator) : this.buildFraction();
            this.reset();
            return result;
        }
    }

    @Override
    @Nonnull
    public List<NumberResult> finish() {
        List<NumberResult> result = this.numerator == null ? Collections.emptyList() : (this.denominator == null ? this.swapAndReturnNumerator(null) : this.buildFraction());
        this.reset();
        return result;
    }

    private List<NumberResult> buildFraction() {
        assert (this.numerator != null) : "this should only be called when numerator is not null";
        assert (this.denominator != null) : "this should only be called when denominator is not null";
        return Collections.singletonList(new NumberResult(this.numerator.getBegin(), this.denominator.getEnd(), this.numerator.getNumerator(), this.denominator.getNumerator(), NumberType.FRACTION));
    }

    private List<NumberResult> swapAndReturnNumerator(@Nullable NumberResult replacement) {
        List<NumberResult> result = Collections.singletonList(this.numerator);
        this.numerator = replacement;
        return result;
    }
}

